/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.List;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSCoding;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.uikit.UIBarButtonItemStyle;
import org.robovm.apple.uikit.UIBarButtonSystemItem;
import org.robovm.apple.uikit.UIBarItem;
import org.robovm.apple.uikit.UIBarMetrics;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIControlState;
import org.robovm.apple.uikit.UIImage;
import org.robovm.apple.uikit.UIOffset;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIBarButtonItem
extends UIBarItem
implements NSCoding {
    private static final Selector handleClick;

    public UIBarButtonItem(UIImage image, UIBarButtonItemStyle style, OnClickListener listener) {
        super(null);
        if (listener != null) {
            ListenerWrapper l = new ListenerWrapper(listener);
            this.initObject(this.init(image, style, (NSObject)l, handleClick));
            this.addStrongRef(l);
        } else {
            this.initObject(this.init(image, style, null, null));
        }
    }

    public UIBarButtonItem(UIImage image, UIImage landscapeImagePhone, UIBarButtonItemStyle style, OnClickListener listener) {
        super(null);
        if (listener != null) {
            ListenerWrapper l = new ListenerWrapper(listener);
            this.initObject(this.init(image, landscapeImagePhone, style, l, handleClick));
            this.addStrongRef(l);
        } else {
            this.initObject(this.init(image, landscapeImagePhone, style, null, null));
        }
    }

    public UIBarButtonItem(String title, UIBarButtonItemStyle style, OnClickListener listener) {
        super(null);
        if (listener != null) {
            ListenerWrapper l = new ListenerWrapper(listener);
            this.initObject(this.init(title, style, (NSObject)l, handleClick));
            this.addStrongRef(l);
        } else {
            this.initObject(this.init(title, style, null, null));
        }
    }

    public UIBarButtonItem(UIBarButtonSystemItem systemItem, OnClickListener listener) {
        super(null);
        if (listener != null) {
            ListenerWrapper l = new ListenerWrapper(listener);
            this.initObject(this.init(systemItem, l, handleClick));
            this.addStrongRef(l);
        } else {
            this.initObject(this.init(systemItem, null, null));
        }
    }

    public UIBarButtonItem() {
    }

    protected UIBarButtonItem(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public UIBarButtonItem(UIImage image, UIBarButtonItemStyle style, NSObject target, Selector action) {
        super(null);
        this.initObject(this.init(image, style, target, action));
    }

    public UIBarButtonItem(UIImage image, UIImage landscapeImagePhone, UIBarButtonItemStyle style, NSObject target, Selector action) {
        super(null);
        this.initObject(this.init(image, landscapeImagePhone, style, target, action));
    }

    public UIBarButtonItem(String title, UIBarButtonItemStyle style, NSObject target, Selector action) {
        super(null);
        this.initObject(this.init(title, style, target, action));
    }

    public UIBarButtonItem(UIBarButtonSystemItem systemItem, NSObject target, Selector action) {
        super(null);
        this.initObject(this.init(systemItem, target, action));
    }

    public UIBarButtonItem(UIView customView) {
        super(null);
        this.initObject(this.init(customView));
    }

    public UIBarButtonItem(NSCoder aDecoder) {
        super(null);
        this.initObject(this.init(aDecoder));
    }

    public void setOnClickListener(OnClickListener listener) {
        NSObject t = this.getTarget();
        if (t instanceof ListenerWrapper) {
            this.removeStrongRef(t);
        }
        ListenerWrapper l = new ListenerWrapper(listener);
        this.setAction(handleClick);
        this.setTarget(l);
        this.addStrongRef(l);
    }

    @Property(selector="style")
    public native UIBarButtonItemStyle getStyle();

    @Property(selector="setStyle:")
    public native void setStyle(UIBarButtonItemStyle var1);

    @Property(selector="width")
    @MachineSizedFloat
    public native double getWidth();

    @Property(selector="setWidth:")
    public native void setWidth(@MachineSizedFloat double var1);

    @Property(selector="possibleTitles")
    @Marshaler(value=NSSet.AsStringListMarshaler.class)
    public native List<String> getPossibleTitles();

    @Property(selector="setPossibleTitles:")
    public native void setPossibleTitles(@Marshaler(value=NSSet.AsStringListMarshaler.class) List<String> var1);

    @Property(selector="customView")
    public native UIView getCustomView();

    @Property(selector="setCustomView:")
    public native void setCustomView(UIView var1);

    @Property(selector="action")
    public native Selector getAction();

    @Property(selector="setAction:")
    public native void setAction(Selector var1);

    @Property(selector="target")
    public native NSObject getTarget();

    @Property(selector="setTarget:", strongRef=true)
    public native void setTarget(NSObject var1);

    @Property(selector="tintColor")
    public native UIColor getTintColor();

    @Property(selector="setTintColor:")
    public native void setTintColor(UIColor var1);

    @Method(selector="initWithImage:style:target:action:")
    @Pointer
    protected native long init(UIImage var1, UIBarButtonItemStyle var2, NSObject var3, Selector var4);

    @Method(selector="initWithImage:landscapeImagePhone:style:target:action:")
    @Pointer
    protected native long init(UIImage var1, UIImage var2, UIBarButtonItemStyle var3, NSObject var4, Selector var5);

    @Method(selector="initWithTitle:style:target:action:")
    @Pointer
    protected native long init(String var1, UIBarButtonItemStyle var2, NSObject var3, Selector var4);

    @Method(selector="initWithBarButtonSystemItem:target:action:")
    @Pointer
    protected native long init(UIBarButtonSystemItem var1, NSObject var2, Selector var3);

    @Method(selector="initWithCustomView:")
    @Pointer
    protected native long init(UIView var1);

    @Method(selector="setBackgroundImage:forState:barMetrics:")
    public native void setBackgroundImage(UIImage var1, UIControlState var2, UIBarMetrics var3);

    @Method(selector="backgroundImageForState:barMetrics:")
    public native UIImage getBackgroundImage(UIControlState var1, UIBarMetrics var2);

    @Method(selector="setBackgroundImage:forState:style:barMetrics:")
    public native void setBackgroundImage(UIImage var1, UIControlState var2, UIBarButtonItemStyle var3, UIBarMetrics var4);

    @Method(selector="backgroundImageForState:style:barMetrics:")
    public native UIImage getBackgroundImage(UIControlState var1, UIBarButtonItemStyle var2, UIBarMetrics var3);

    @Method(selector="setBackgroundVerticalPositionAdjustment:forBarMetrics:")
    public native void setBackgroundVerticalPositionAdjustment(@MachineSizedFloat double var1, UIBarMetrics var3);

    @Method(selector="backgroundVerticalPositionAdjustmentForBarMetrics:")
    @MachineSizedFloat
    public native double getBackgroundVerticalPositionAdjustment(UIBarMetrics var1);

    @Method(selector="setTitlePositionAdjustment:forBarMetrics:")
    public native void setTitlePositionAdjustment(@ByVal UIOffset var1, UIBarMetrics var2);

    @Method(selector="titlePositionAdjustmentForBarMetrics:")
    @ByVal
    public native UIOffset getTitlePositionAdjustment(UIBarMetrics var1);

    @Method(selector="setBackButtonBackgroundImage:forState:barMetrics:")
    public native void setBackButtonBackgroundImage(UIImage var1, UIControlState var2, UIBarMetrics var3);

    @Method(selector="backButtonBackgroundImageForState:barMetrics:")
    public native UIImage getBackButtonBackgroundImage(UIControlState var1, UIBarMetrics var2);

    @Method(selector="setBackButtonTitlePositionAdjustment:forBarMetrics:")
    public native void setBackButtonTitlePositionAdjustment(@ByVal UIOffset var1, UIBarMetrics var2);

    @Method(selector="backButtonTitlePositionAdjustmentForBarMetrics:")
    @ByVal
    public native UIOffset getBackButtonTitlePositionAdjustment(UIBarMetrics var1);

    @Method(selector="setBackButtonBackgroundVerticalPositionAdjustment:forBarMetrics:")
    public native void setBackButtonBackgroundVerticalPositionAdjustment(@MachineSizedFloat double var1, UIBarMetrics var3);

    @Method(selector="backButtonBackgroundVerticalPositionAdjustmentForBarMetrics:")
    @MachineSizedFloat
    public native double getBackButtonBackgroundVerticalPositionAdjustment(UIBarMetrics var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(UIBarButtonItem.class);
        handleClick = Selector.register((String)"handleClick");
    }

    private static class ListenerWrapper
    extends NSObject {
        private final OnClickListener listener;

        private ListenerWrapper(OnClickListener listener) {
            this.listener = listener;
        }

        @Method(selector="handleClick")
        private void handleClick(UIBarButtonItem barButtonItem) {
            this.listener.onClick(barButtonItem);
        }
    }

    public static interface OnClickListener {
        public void onClick(UIBarButtonItem var1);
    }

    public static class UIBarButtonItemPtr
    extends Ptr<UIBarButtonItem, UIBarButtonItemPtr> {
    }
}

