/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.uikit.NSTextLayoutOrientation;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="UIKit")
public class NSTextLayoutSection
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    public NSTextLayoutSection(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSTextLayoutSection() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSTextLayoutOrientation getOrientation() {
        if (this.data.containsKey(NSTextLayoutSection.OrientationKey())) {
            NSNumber val = (NSNumber)this.data.get(NSTextLayoutSection.OrientationKey());
            return NSTextLayoutOrientation.valueOf(val.intValue());
        }
        return null;
    }

    public NSTextLayoutSection setOrientation(NSTextLayoutOrientation orientation) {
        this.data.put(NSTextLayoutSection.OrientationKey(), NSNumber.valueOf((int)orientation.value()));
        return this;
    }

    public NSRange getRange() {
        if (this.data.containsKey(NSTextLayoutSection.RangeKey())) {
            NSValue val = (NSValue)this.data.get(NSTextLayoutSection.RangeKey());
            return val.rangeValue();
        }
        return null;
    }

    public NSTextLayoutSection setRange(NSRange range) {
        this.data.put(NSTextLayoutSection.RangeKey(), NSValue.valueOf(range));
        return this;
    }

    @GlobalValue(symbol="NSTextLayoutSectionOrientation", optional=true)
    protected static native NSString OrientationKey();

    @GlobalValue(symbol="NSTextLayoutSectionRange", optional=true)
    protected static native NSString RangeKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSTextLayoutSection.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSTextLayoutSection toObject(Class<NSTextLayoutSection> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSTextLayoutSection(o);
        }

        @MarshalsPointer
        public static long toNative(NSTextLayoutSection o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

