/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSStringEncoding;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.apple.uikit.NSAttributedStringDocumentAttribute;
import org.robovm.apple.uikit.NSDocumentType;
import org.robovm.apple.uikit.NSDocumentViewMode;
import org.robovm.apple.uikit.NSTextLayoutSection;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIEdgeInsets;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="UIKit")
public class NSAttributedStringDocumentAttributes {
    private NSDictionary<NSString, NSObject> data;

    public NSAttributedStringDocumentAttributes(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSAttributedStringDocumentAttributes() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSAttributedStringDocumentAttributes set(String attribute, NSObject value) {
        this.data.put(new NSString(attribute), value);
        return this;
    }

    public NSAttributedStringDocumentAttributes set(NSAttributedStringDocumentAttribute attribute, NSObject value) {
        this.data.put(attribute.value(), value);
        return this;
    }

    public NSObject get(String attribute) {
        return this.data.get(new NSString(attribute));
    }

    public NSObject get(NSAttributedStringDocumentAttribute attribute) {
        return this.data.get(attribute.value());
    }

    public boolean contains(String attribute) {
        return this.data.containsKey(new NSString(attribute));
    }

    public boolean contains(NSAttributedStringDocumentAttribute attribute) {
        return this.data.containsKey(attribute.value());
    }

    public NSDocumentType getDocumentType() {
        if (this.contains(NSAttributedStringDocumentAttribute.DocumentType)) {
            NSString val = (NSString)this.get(NSAttributedStringDocumentAttribute.DocumentType);
            return NSDocumentType.valueOf(val);
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setDocumentType(NSDocumentType type) {
        this.set(NSAttributedStringDocumentAttribute.DocumentType, (NSObject)type.value());
        return this;
    }

    public NSStringEncoding getCharacterEncoding() {
        if (this.contains(NSAttributedStringDocumentAttribute.CharacterEncoding)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.CharacterEncoding);
            return NSStringEncoding.valueOf(val.intValue());
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setCharacterEncoding(NSStringEncoding encoding) {
        this.set(NSAttributedStringDocumentAttribute.CharacterEncoding, (NSObject)NSNumber.valueOf((int)encoding.value()));
        return this;
    }

    public NSAttributedStringAttributes getDefaultAttributes() {
        if (this.contains(NSAttributedStringDocumentAttribute.DefaultAttributes)) {
            NSDictionary val = (NSDictionary)this.get(NSAttributedStringDocumentAttribute.DefaultAttributes);
            return new NSAttributedStringAttributes(val);
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setDefaultAttributes(NSAttributedStringAttributes attributes) {
        this.set(NSAttributedStringDocumentAttribute.DefaultAttributes, attributes.getDictionary());
        return this;
    }

    public CGSize getPaperSize() {
        if (this.contains(NSAttributedStringDocumentAttribute.PaperSize)) {
            NSValue val = (NSValue)this.get(NSAttributedStringDocumentAttribute.PaperSize);
            return val.sizeValue();
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setPaperSize(CGSize paperSize) {
        this.set(NSAttributedStringDocumentAttribute.PaperSize, (NSObject)NSValue.valueOf(paperSize));
        return this;
    }

    public UIEdgeInsets getPaperMargin() {
        if (this.contains(NSAttributedStringDocumentAttribute.PaperMargin)) {
            NSValue val = (NSValue)this.get(NSAttributedStringDocumentAttribute.PaperMargin);
            return val.edgeInsetsValue();
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setPaperMargin(UIEdgeInsets paperMargin) {
        this.set(NSAttributedStringDocumentAttribute.PaperMargin, (NSObject)NSValue.valueOf(paperMargin));
        return this;
    }

    public CGSize getViewSize() {
        if (this.contains(NSAttributedStringDocumentAttribute.ViewSize)) {
            NSValue val = (NSValue)this.get(NSAttributedStringDocumentAttribute.ViewSize);
            return val.sizeValue();
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setViewSize(CGSize viewSize) {
        this.set(NSAttributedStringDocumentAttribute.ViewSize, (NSObject)NSValue.valueOf(viewSize));
        return this;
    }

    public double getViewZoom() {
        if (this.contains(NSAttributedStringDocumentAttribute.ViewZoom)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.ViewZoom);
            return val.doubleValue();
        }
        return 100.0;
    }

    public NSAttributedStringDocumentAttributes setViewZoom(double viewZoom) {
        this.set(NSAttributedStringDocumentAttribute.ViewZoom, (NSObject)NSNumber.valueOf(viewZoom));
        return this;
    }

    public NSDocumentViewMode getViewMode() {
        if (this.contains(NSAttributedStringDocumentAttribute.ViewMode)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.ViewMode);
            return NSDocumentViewMode.values()[val.intValue()];
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setViewMode(NSDocumentViewMode viewMode) {
        this.set(NSAttributedStringDocumentAttribute.ViewMode, (NSObject)NSNumber.valueOf(viewMode.ordinal()));
        return this;
    }

    public boolean isReadOnly() {
        if (this.contains(NSAttributedStringDocumentAttribute.ReadOnly)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.ReadOnly);
            return val.intValue() != 0;
        }
        return false;
    }

    public NSAttributedStringDocumentAttributes setReadOnly(boolean readOnly) {
        this.set(NSAttributedStringDocumentAttribute.ReadOnly, (NSObject)NSNumber.valueOf(readOnly ? 1 : 0));
        return this;
    }

    public UIColor getBackgroundColor() {
        if (this.contains(NSAttributedStringDocumentAttribute.BackgroundColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringDocumentAttribute.BackgroundColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setBackgroundColor(UIColor backgroundColor) {
        this.set(NSAttributedStringDocumentAttribute.BackgroundColor, (NSObject)backgroundColor);
        return this;
    }

    public double getHyphenationFactor() {
        if (this.contains(NSAttributedStringDocumentAttribute.HyphenationFactor)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.HyphenationFactor);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringDocumentAttributes setHyphenationFactor(double factor) {
        this.set(NSAttributedStringDocumentAttribute.HyphenationFactor, (NSObject)NSNumber.valueOf(factor));
        return this;
    }

    public double getDefaultTabInterval() {
        if (this.contains(NSAttributedStringDocumentAttribute.DefaultTabInterval)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.DefaultTabInterval);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringDocumentAttributes setDefaultTabInterval(double interval) {
        this.set(NSAttributedStringDocumentAttribute.DefaultTabInterval, (NSObject)NSNumber.valueOf(interval));
        return this;
    }

    public List<NSTextLayoutSection> getTextLayoutSections() {
        ArrayList<NSTextLayoutSection> list = new ArrayList<NSTextLayoutSection>();
        if (this.contains(NSAttributedStringDocumentAttribute.TextLayoutSections)) {
            NSArray val = (NSArray)this.get(NSAttributedStringDocumentAttribute.TextLayoutSections);
            for (NSDictionary e : val) {
                list.add(new NSTextLayoutSection(e));
            }
        }
        return list;
    }

    public NSAttributedStringDocumentAttributes setTextLayoutSections(List<NSTextLayoutSection> sections) {
        NSMutableArray<NSDictionary<NSString, NSObject>> list = new NSMutableArray<NSDictionary<NSString, NSObject>>();
        for (NSTextLayoutSection e : sections) {
            list.add(e.getDictionary());
        }
        this.set(NSAttributedStringDocumentAttribute.TextLayoutSections, list);
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSAttributedStringDocumentAttributes.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSAttributedStringDocumentAttributes toObject(Class<NSAttributedStringDocumentAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSAttributedStringDocumentAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSAttributedStringDocumentAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

