/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSLigature;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSTextDirection;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.NSAttributedStringAttribute;
import org.robovm.apple.uikit.NSParagraphStyle;
import org.robovm.apple.uikit.NSShadow;
import org.robovm.apple.uikit.NSTextAttachment;
import org.robovm.apple.uikit.NSTextEffect;
import org.robovm.apple.uikit.NSUnderlineStyle;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIFont;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="UIKit")
public class NSAttributedStringAttributes {
    private NSDictionary<NSString, NSObject> data;

    public NSAttributedStringAttributes(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSAttributedStringAttributes() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSAttributedStringAttributes set(String attribute, NSObject value) {
        this.data.put(new NSString(attribute), value);
        return this;
    }

    public NSAttributedStringAttributes set(NSAttributedStringAttribute attribute, NSObject value) {
        this.data.put(attribute.value(), value);
        return this;
    }

    public NSObject get(String attribute) {
        return this.data.get(new NSString(attribute));
    }

    public NSObject get(NSAttributedStringAttribute attribute) {
        return this.data.get(attribute.value());
    }

    public boolean contains(String attribute) {
        return this.data.containsKey(new NSString(attribute));
    }

    public boolean contains(NSAttributedStringAttribute attribute) {
        return this.data.containsKey(attribute.value());
    }

    public UIFont getFont() {
        if (this.contains(NSAttributedStringAttribute.Font)) {
            UIFont val = (UIFont)this.get(NSAttributedStringAttribute.Font);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setFont(UIFont font) {
        this.set(NSAttributedStringAttribute.Font, (NSObject)font);
        return this;
    }

    public NSParagraphStyle getParagraphStyle() {
        if (this.contains(NSAttributedStringAttribute.ParagraphStyle)) {
            NSParagraphStyle val = (NSParagraphStyle)this.get(NSAttributedStringAttribute.ParagraphStyle);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setParagraphStyle(NSParagraphStyle paragraphStyle) {
        this.set(NSAttributedStringAttribute.ParagraphStyle, (NSObject)paragraphStyle);
        return this;
    }

    public UIColor getForegroundColor() {
        if (this.contains(NSAttributedStringAttribute.ForegroundColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.ForegroundColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setForegroundColor(UIColor color) {
        this.set(NSAttributedStringAttribute.ForegroundColor, (NSObject)color);
        return this;
    }

    public UIColor getBackgroundColor() {
        if (this.contains(NSAttributedStringAttribute.BackgroundColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.BackgroundColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setBackgroundColor(UIColor color) {
        this.set(NSAttributedStringAttribute.BackgroundColor, (NSObject)color);
        return this;
    }

    public NSLigature getLigature() {
        if (this.contains(NSAttributedStringAttribute.Ligature)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Ligature);
            return NSLigature.values()[val.intValue()];
        }
        return NSLigature.Default;
    }

    public NSAttributedStringAttributes setLigature(NSLigature ligature) {
        this.set(NSAttributedStringAttribute.Ligature, (NSObject)NSNumber.valueOf(ligature.ordinal()));
        return this;
    }

    public double getKerning() {
        if (this.contains(NSAttributedStringAttribute.Kern)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Kern);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setKerning(double kern) {
        this.set(NSAttributedStringAttribute.Kern, (NSObject)NSNumber.valueOf(kern));
        return this;
    }

    public NSUnderlineStyle getStrikethroughStyle() {
        if (this.contains(NSAttributedStringAttribute.StrikethroughStyle)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.StrikethroughStyle);
            return NSUnderlineStyle.valueOf(val.intValue());
        }
        return NSUnderlineStyle.StyleNone;
    }

    public NSAttributedStringAttributes setStrikethroughStyle(NSUnderlineStyle style) {
        this.set(NSAttributedStringAttribute.StrikethroughStyle, (NSObject)NSNumber.valueOf((int)style.value()));
        return this;
    }

    public NSUnderlineStyle getUnderlineStyle() {
        if (this.contains(NSAttributedStringAttribute.UnderlineStyle)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.UnderlineStyle);
            return NSUnderlineStyle.valueOf(val.intValue());
        }
        return NSUnderlineStyle.StyleNone;
    }

    public NSAttributedStringAttributes setUnderlineStyle(NSUnderlineStyle style) {
        this.set(NSAttributedStringAttribute.UnderlineStyle, (NSObject)NSNumber.valueOf((int)style.value()));
        return this;
    }

    public UIColor getStrokeColor() {
        if (this.contains(NSAttributedStringAttribute.StrokeColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.StrokeColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setStrokeColor(UIColor color) {
        this.set(NSAttributedStringAttribute.StrokeColor, (NSObject)color);
        return this;
    }

    public double getStrokeWidth() {
        if (this.contains(NSAttributedStringAttribute.StrokeWidth)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.StrokeWidth);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setStrokeWidth(double width) {
        this.set(NSAttributedStringAttribute.StrokeWidth, (NSObject)NSNumber.valueOf(width));
        return this;
    }

    public NSShadow getShadow() {
        if (this.contains(NSAttributedStringAttribute.Shadow)) {
            NSShadow val = (NSShadow)this.get(NSAttributedStringAttribute.Shadow);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setShadow(NSShadow shadow) {
        this.set(NSAttributedStringAttribute.Shadow, (NSObject)shadow);
        return this;
    }

    public NSTextEffect getTextEffect() {
        if (this.contains(NSAttributedStringAttribute.TextEffect)) {
            NSString val = (NSString)this.get(NSAttributedStringAttribute.TextEffect);
            return NSTextEffect.valueOf(val);
        }
        return null;
    }

    public NSAttributedStringAttributes setTextEffect(NSTextEffect textEffect) {
        this.set(NSAttributedStringAttribute.TextEffect, (NSObject)textEffect.value());
        return this;
    }

    public NSTextAttachment getAttachment() {
        if (this.contains(NSAttributedStringAttribute.Attachment)) {
            NSTextAttachment val = (NSTextAttachment)this.get(NSAttributedStringAttribute.Attachment);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setAttachment(NSTextAttachment attachment) {
        this.set(NSAttributedStringAttribute.Attachment, (NSObject)attachment);
        return this;
    }

    public NSURL getLink() {
        if (this.contains(NSAttributedStringAttribute.Link)) {
            NSURL val = (NSURL)this.get(NSAttributedStringAttribute.Link);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setLink(NSURL link) {
        this.set(NSAttributedStringAttribute.Link, (NSObject)link);
        return this;
    }

    public double getBaselineOffset() {
        if (this.contains(NSAttributedStringAttribute.BaselineOffset)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.BaselineOffset);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setBaselineOffset(double offset) {
        this.set(NSAttributedStringAttribute.BaselineOffset, (NSObject)NSNumber.valueOf(offset));
        return this;
    }

    public UIColor getUnderlineColor() {
        if (this.contains(NSAttributedStringAttribute.UnderlineColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.UnderlineColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setUnderlineColor(UIColor color) {
        this.set(NSAttributedStringAttribute.UnderlineColor, (NSObject)color);
        return this;
    }

    public UIColor getStrikethroughColor() {
        if (this.contains(NSAttributedStringAttribute.StrikethroughColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.StrikethroughColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setStrikethroughColor(UIColor color) {
        this.set(NSAttributedStringAttribute.StrikethroughColor, (NSObject)color);
        return this;
    }

    public double getObliqueness() {
        if (this.contains(NSAttributedStringAttribute.Obliqueness)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Obliqueness);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setObliqueness(double obliqueness) {
        this.set(NSAttributedStringAttribute.Obliqueness, (NSObject)NSNumber.valueOf(obliqueness));
        return this;
    }

    public double getExpansion() {
        if (this.contains(NSAttributedStringAttribute.Expansion)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Expansion);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setExpansion(double expansion) {
        this.set(NSAttributedStringAttribute.Expansion, (NSObject)NSNumber.valueOf(expansion));
        return this;
    }

    public List<NSTextDirection> getWritingDirections() {
        ArrayList<NSTextDirection> list = new ArrayList<NSTextDirection>();
        if (this.contains(NSAttributedStringAttribute.WritingDirection)) {
            NSArray val = (NSArray)this.get(NSAttributedStringAttribute.WritingDirection);
            for (NSNumber n : val) {
                list.add(NSTextDirection.values()[n.intValue()]);
            }
        }
        return list;
    }

    public NSAttributedStringAttributes setWritingDirections(List<NSTextDirection> writingDirections) {
        NSMutableArray<NSNumber> list = new NSMutableArray<NSNumber>();
        for (NSTextDirection n : writingDirections) {
            list.add(NSNumber.valueOf(n.ordinal()));
        }
        this.set(NSAttributedStringAttribute.WritingDirection, list);
        return this;
    }

    public boolean isVerticalText() {
        if (this.contains(NSAttributedStringAttribute.VerticalGlyphForm)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.VerticalGlyphForm);
            return val.intValue() == 1;
        }
        return false;
    }

    public NSAttributedStringAttributes setVerticalText(boolean vertical) {
        this.set(NSAttributedStringAttribute.VerticalGlyphForm, (NSObject)(vertical ? NSNumber.valueOf(1) : NSNumber.valueOf(0)));
        return this;
    }

    public boolean isSpeechPunctuation() {
        if (this.contains(NSAttributedStringAttribute.SpeechPunctuation)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.SpeechPunctuation);
            return val.booleanValue();
        }
        return false;
    }

    public NSAttributedStringAttributes setSpeechPunctuation(boolean punctuation) {
        this.set(NSAttributedStringAttribute.SpeechPunctuation, (NSObject)NSNumber.valueOf(punctuation));
        return this;
    }

    public String getSpeechLanguage() {
        if (this.contains(NSAttributedStringAttribute.SpeechLanguage)) {
            NSString val = (NSString)this.get(NSAttributedStringAttribute.SpeechLanguage);
            return val.toString();
        }
        return null;
    }

    public NSAttributedStringAttributes setSpeechLanguage(String language) {
        this.set(NSAttributedStringAttribute.SpeechLanguage, (NSObject)new NSString(language));
        return this;
    }

    public double getSpeechPitch() {
        if (this.contains(NSAttributedStringAttribute.SpeechPitch)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.SpeechPitch);
            return val.doubleValue();
        }
        return 1.0;
    }

    public NSAttributedStringAttributes setSpeechPitch(double pitch) {
        this.set(NSAttributedStringAttribute.SpeechPitch, (NSObject)NSNumber.valueOf(pitch));
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSAttributedStringAttributes.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSAttributedStringAttributes toObject(Class<NSAttributedStringAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSAttributedStringAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSAttributedStringAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

