/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.security.SecTrustResultType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecTrustResult
extends CFDictionaryWrapper {
    SecTrustResult(CFDictionary data) {
        super(data);
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public NSDate getEvaluationDate() {
        if (this.has(Keys.EvaluationDate())) {
            NSDate val = this.get(Keys.EvaluationDate(), NSDate.class);
            return val;
        }
        return null;
    }

    public boolean isExtendedValidation() {
        if (this.has(Keys.ExtendedValidation())) {
            CFBoolean val = this.get(Keys.ExtendedValidation(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public String getOrganizationName() {
        if (this.has(Keys.OrganizationName())) {
            CFString val = this.get(Keys.OrganizationName(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecTrustResultType getResultValue() {
        if (this.has(Keys.ResultValue())) {
            CFNumber val = this.get(Keys.ResultValue(), CFNumber.class);
            return SecTrustResultType.valueOf(val.longValue());
        }
        return null;
    }

    public boolean isRevocationChecked() {
        if (this.has(Keys.RevocationChecked())) {
            CFBoolean val = this.get(Keys.RevocationChecked(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public NSDate getRevocationValidUntilDate() {
        if (this.has(Keys.RevocationValidUntilDate())) {
            NSDate val = this.get(Keys.RevocationValidUntilDate(), NSDate.class);
            return val;
        }
        return null;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecTrustEvaluationDate", optional=true)
        public static native CFType EvaluationDate();

        @GlobalValue(symbol="kSecTrustExtendedValidation", optional=true)
        public static native CFType ExtendedValidation();

        @GlobalValue(symbol="kSecTrustOrganizationName", optional=true)
        public static native CFType OrganizationName();

        @GlobalValue(symbol="kSecTrustResultValue", optional=true)
        public static native CFType ResultValue();

        @GlobalValue(symbol="kSecTrustRevocationChecked", optional=true)
        public static native CFType RevocationChecked();

        @GlobalValue(symbol="kSecTrustRevocationValidUntilDate", optional=true)
        public static native CFType RevocationValidUntilDate();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecTrustResult> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecTrustResult> list = new ArrayList<SecTrustResult>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecTrustResult(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecTrustResult> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecTrustResult i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecTrustResult toObject(Class<SecTrustResult> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecTrustResult(o);
        }

        @MarshalsPointer
        public static long toNative(SecTrustResult o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

