/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.security.SecAttributes;
import org.robovm.apple.security.SecClass;
import org.robovm.apple.security.SecMatch;
import org.robovm.apple.security.SecReturn;
import org.robovm.apple.security.SecValue;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecQuery
extends CFDictionaryWrapper {
    SecQuery(CFDictionary data) {
        super(data);
    }

    public SecQuery() {
    }

    public SecQuery setAttributes(SecAttributes attributes) {
        this.data.putAll(attributes.getDictionary());
        return this;
    }

    public SecAttributes getAttributes() {
        return new SecAttributes(this.data);
    }

    public SecQuery setMatch(SecMatch match) {
        this.data.putAll(match.getDictionary());
        return this;
    }

    public SecMatch getMatch() {
        return new SecMatch(this.data);
    }

    public SecQuery setReturn(SecReturn returnOpts) {
        this.data.putAll(returnOpts.getDictionary());
        return this;
    }

    public SecReturn getReturn() {
        return new SecReturn(this.data);
    }

    public SecQuery setValue(SecValue value) {
        this.data.putAll(value.getDictionary());
        return this;
    }

    public SecValue getValue() {
        return new SecValue(this.data);
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public SecQuery set(CFType key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public SecClass getClassType() {
        if (this.has(Keys.Class())) {
            CFType val = this.get(Keys.Class(), CFType.class);
            return SecClass.valueOf(val);
        }
        return null;
    }

    public SecQuery setClassType(SecClass classType) {
        this.set(Keys.Class(), (NativeObject)classType.value());
        return this;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecClass", optional=true)
        public static native CFType Class();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecQuery> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecQuery> list = new ArrayList<SecQuery>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecQuery(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecQuery> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecQuery i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecQuery toObject(Class<SecQuery> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecQuery(o);
        }

        @MarshalsPointer
        public static long toNative(SecQuery o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

