/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.security.SecRevocationPolicyFlags;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecPolicyProperties
extends CFDictionaryWrapper {
    SecPolicyProperties(CFDictionary data) {
        super(data);
    }

    public SecPolicyProperties() {
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public SecPolicyProperties set(CFType key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public String getOid() {
        if (this.has(Keys.Oid())) {
            CFString val = this.get(Keys.Oid(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecPolicyProperties setOid(String oid) {
        this.set(Keys.Oid(), new CFString(oid));
        return this;
    }

    public String getName() {
        if (this.has(Keys.Name())) {
            CFString val = this.get(Keys.Name(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecPolicyProperties setName(String name) {
        this.set(Keys.Name(), new CFString(name));
        return this;
    }

    public boolean isClient() {
        if (this.has(Keys.Client())) {
            CFBoolean val = this.get(Keys.Client(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecPolicyProperties setClient(boolean client) {
        this.set(Keys.Client(), CFBoolean.valueOf(client));
        return this;
    }

    public SecRevocationPolicyFlags getRevocationFlags() {
        if (this.has(Keys.RevocationFlags())) {
            CFNumber val = this.get(Keys.RevocationFlags(), CFNumber.class);
            return new SecRevocationPolicyFlags(val.longValue());
        }
        return null;
    }

    public SecPolicyProperties setRevocationFlags(SecRevocationPolicyFlags revocationFlags) {
        this.set(Keys.RevocationFlags(), CFNumber.valueOf(revocationFlags.value()));
        return this;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecPolicyOid", optional=true)
        public static native CFType Oid();

        @GlobalValue(symbol="kSecPolicyName", optional=true)
        public static native CFType Name();

        @GlobalValue(symbol="kSecPolicyClient", optional=true)
        public static native CFType Client();

        @GlobalValue(symbol="kSecPolicyRevocationFlags", optional=true)
        public static native CFType RevocationFlags();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecPolicyProperties> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecPolicyProperties> list = new ArrayList<SecPolicyProperties>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecPolicyProperties(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecPolicyProperties> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecPolicyProperties i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecPolicyProperties toObject(Class<SecPolicyProperties> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecPolicyProperties(o);
        }

        @MarshalsPointer
        public static long toNative(SecPolicyProperties o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

