/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.security.SecMatchLimit;
import org.robovm.apple.security.SecPolicy;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecMatch
extends CFDictionaryWrapper {
    SecMatch(CFDictionary data) {
        super(data);
    }

    public SecMatch() {
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public SecMatch set(CFType key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public SecPolicy getPolicy() {
        if (this.has(Keys.Policy())) {
            SecPolicy val = this.get(Keys.Policy(), SecPolicy.class);
            return val;
        }
        return null;
    }

    public SecMatch setPolicy(SecPolicy policy) {
        this.set(Keys.Policy(), policy);
        return this;
    }

    public NSArray<NSData> getIssuers() {
        if (this.has(Keys.Issuers())) {
            NSArray val = this.get(Keys.Issuers(), NSArray.class);
            return val;
        }
        return null;
    }

    public SecMatch setIssuers(NSArray<NSData> issuers) {
        this.set(Keys.Issuers(), (NativeObject)issuers);
        return this;
    }

    public String getEmailAddressIfPresent() {
        if (this.has(Keys.EmailAddressIfPresent())) {
            CFString val = this.get(Keys.EmailAddressIfPresent(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecMatch setEmailAddressIfPresent(String emailAddressIfPresent) {
        this.set(Keys.EmailAddressIfPresent(), new CFString(emailAddressIfPresent));
        return this;
    }

    public String getSubjectContains() {
        if (this.has(Keys.SubjectContains())) {
            CFString val = this.get(Keys.SubjectContains(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecMatch setSubjectContains(String subjectContains) {
        this.set(Keys.SubjectContains(), new CFString(subjectContains));
        return this;
    }

    public boolean isCaseInsensitive() {
        if (this.has(Keys.CaseInsensitive())) {
            CFBoolean val = this.get(Keys.CaseInsensitive(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecMatch setCaseInsensitive(boolean caseInsensitive) {
        this.set(Keys.CaseInsensitive(), CFBoolean.valueOf(caseInsensitive));
        return this;
    }

    public boolean isTrustedOnly() {
        if (this.has(Keys.TrustedOnly())) {
            CFBoolean val = this.get(Keys.TrustedOnly(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecMatch setTrustedOnly(boolean trustedOnly) {
        this.set(Keys.TrustedOnly(), CFBoolean.valueOf(trustedOnly));
        return this;
    }

    public NSDate getValidOnDate() {
        if (this.has(Keys.ValidOnDate())) {
            NSDate val = this.get(Keys.ValidOnDate(), NSDate.class);
            return val;
        }
        return null;
    }

    public SecMatch setValidOnDate(NSDate validOnDate) {
        this.set(Keys.ValidOnDate(), (NativeObject)validOnDate);
        return this;
    }

    public SecMatchLimit getLimit() {
        if (this.has(Keys.Limit())) {
            CFType val = this.get(Keys.Limit(), CFType.class);
            return SecMatchLimit.valueOf(val);
        }
        return null;
    }

    public SecMatch setLimit(SecMatchLimit limit) {
        this.set(Keys.Limit(), (NativeObject)limit.value());
        return this;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecMatchPolicy", optional=true)
        public static native CFType Policy();

        @GlobalValue(symbol="kSecMatchItemList", optional=true)
        public static native CFType ItemList();

        @GlobalValue(symbol="kSecMatchSearchList", optional=true)
        public static native CFType SearchList();

        @GlobalValue(symbol="kSecMatchIssuers", optional=true)
        public static native CFType Issuers();

        @GlobalValue(symbol="kSecMatchEmailAddressIfPresent", optional=true)
        public static native CFType EmailAddressIfPresent();

        @GlobalValue(symbol="kSecMatchSubjectContains", optional=true)
        public static native CFType SubjectContains();

        @GlobalValue(symbol="kSecMatchCaseInsensitive", optional=true)
        public static native CFType CaseInsensitive();

        @GlobalValue(symbol="kSecMatchTrustedOnly", optional=true)
        public static native CFType TrustedOnly();

        @GlobalValue(symbol="kSecMatchValidOnDate", optional=true)
        public static native CFType ValidOnDate();

        @GlobalValue(symbol="kSecMatchLimit", optional=true)
        public static native CFType Limit();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecMatch> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecMatch> list = new ArrayList<SecMatch>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecMatch(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecMatch> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecMatch i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecMatch toObject(Class<SecMatch> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecMatch(o);
        }

        @MarshalsPointer
        public static long toNative(SecMatch o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

