/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.security.SecAttributes;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecKeyParameters
extends CFDictionaryWrapper {
    SecKeyParameters(CFDictionary data) {
        super(data);
    }

    public SecKeyParameters() {
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public SecKeyParameters set(CFType key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public SecAttributes getPrivateAttributes() {
        if (this.has(Keys.PrivateAttributes())) {
            CFDictionary val = this.get(Keys.PrivateAttributes(), CFDictionary.class);
            return new SecAttributes(val);
        }
        return null;
    }

    public SecKeyParameters setPrivateAttributes(SecAttributes privateAttributes) {
        this.set(Keys.PrivateAttributes(), privateAttributes.getDictionary());
        return this;
    }

    public SecAttributes getPublicAttributes() {
        if (this.has(Keys.PublicAttributes())) {
            CFDictionary val = this.get(Keys.PublicAttributes(), CFDictionary.class);
            return new SecAttributes(val);
        }
        return null;
    }

    public SecKeyParameters setPublicAttributes(SecAttributes publicAttributes) {
        this.set(Keys.PublicAttributes(), publicAttributes.getDictionary());
        return this;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecPrivateKeyAttrs", optional=true)
        public static native CFType PrivateAttributes();

        @GlobalValue(symbol="kSecPublicKeyAttrs", optional=true)
        public static native CFType PublicAttributes();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecKeyParameters> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecKeyParameters> list = new ArrayList<SecKeyParameters>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecKeyParameters(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecKeyParameters> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecKeyParameters i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecKeyParameters toObject(Class<SecKeyParameters> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecKeyParameters(o);
        }

        @MarshalsPointer
        public static long toNative(SecKeyParameters o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

