/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.security.SecAttributes;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecCredential
extends CFDictionaryWrapper {
    SecCredential(CFDictionary data) {
        super(data);
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public String getPassword() {
        if (this.has(Keys.Password())) {
            CFString val = this.get(Keys.Password(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getServer() {
        if (this.has(SecAttributes.Keys.Server())) {
            CFString val = this.get(SecAttributes.Keys.Server(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getAccount() {
        if (this.has(SecAttributes.Keys.Account())) {
            CFString val = this.get(SecAttributes.Keys.Account(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public int getPort() {
        if (this.has(SecAttributes.Keys.Port())) {
            CFNumber val = this.get(SecAttributes.Keys.Port(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecSharedPassword", optional=true)
        public static native CFType Password();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecCredential> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecCredential> list = new ArrayList<SecCredential>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecCredential(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecCredential> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecCredential i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecCredential toObject(Class<SecCredential> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecCredential(o);
        }

        @MarshalsPointer
        public static long toNative(SecCredential o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

