/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.scenekit;

import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.scenekit.SCNConsistencyErrorCode;
import org.robovm.apple.scenekit.SCNConsistencyErrorUserInfo;
import org.robovm.apple.scenekit.SCNErrorCode;
import org.robovm.apple.scenekit.SCNErrorUserInfoKey;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="SceneKit")
public class SCNError
extends NSError {
    protected SCNError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Override
    public NSErrorCode getErrorCode() {
        Enum code = null;
        try {
            code = SCNConsistencyErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException e) {
            try {
                code = SCNErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return code;
    }

    public SCNConsistencyErrorUserInfo getConsistencyError() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(SCNErrorUserInfoKey.DetailedErrors)) {
            NSDictionary val = (NSDictionary)data.get(SCNErrorUserInfoKey.DetailedErrors);
            return new SCNConsistencyErrorUserInfo(val);
        }
        return null;
    }

    @GlobalValue(symbol="SCNErrorDomain", optional=true)
    public static native String getClassDomain();

    static {
        Bro.bind(SCNError.class);
    }
}

