/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.passkit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.passkit.PKPass;
import org.robovm.apple.passkit.PKRemovedPassInfo;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="PassKit")
public class PKPassLibraryNotificationArgs
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected PKPassLibraryNotificationArgs(NSNotification notification) {
        this.data = notification.getUserInfo();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSArray<PKPass> getAddedPasses() {
        if (this.data.containsKey(PKPassLibraryNotificationArgs.AddedPassesKey())) {
            NSArray val = (NSArray)this.data.get(PKPassLibraryNotificationArgs.AddedPassesKey());
            return val;
        }
        return null;
    }

    public NSArray<PKPass> getReplacementPasses() {
        if (this.data.containsKey(PKPassLibraryNotificationArgs.ReplacementPassesKey())) {
            NSArray val = (NSArray)this.data.get(PKPassLibraryNotificationArgs.ReplacementPassesKey());
            return val;
        }
        return null;
    }

    public List<PKRemovedPassInfo> getRemovedPassInfos() {
        if (this.data.containsKey(PKPassLibraryNotificationArgs.RemovedPassInfosKey())) {
            NSArray val = (NSArray)this.data.get(PKPassLibraryNotificationArgs.RemovedPassInfosKey());
            ArrayList<PKRemovedPassInfo> list = new ArrayList<PKRemovedPassInfo>();
            for (NSDictionary v : val) {
                list.add(new PKRemovedPassInfo(v));
            }
            return list;
        }
        return null;
    }

    @GlobalValue(symbol="PKPassLibraryAddedPassesUserInfoKey", optional=true)
    protected static native NSString AddedPassesKey();

    @GlobalValue(symbol="PKPassLibraryReplacementPassesUserInfoKey", optional=true)
    protected static native NSString ReplacementPassesKey();

    @GlobalValue(symbol="PKPassLibraryRemovedPassInfosUserInfoKey", optional=true)
    protected static native NSString RemovedPassInfosKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(PKPassLibraryNotificationArgs.class);
    }
}

