/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.multipeerconnectivity;

import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOutputStream;
import org.robovm.apple.foundation.NSProgress;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.multipeerconnectivity.MCEncryptionPreference;
import org.robovm.apple.multipeerconnectivity.MCPeerID;
import org.robovm.apple.multipeerconnectivity.MCSessionDelegate;
import org.robovm.apple.multipeerconnectivity.MCSessionSendDataMode;
import org.robovm.apple.security.SecIdentity;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MultipeerConnectivity")
@NativeClass
public class MCSession
extends NSObject {
    public MCSession() {
    }

    protected MCSession(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MCSession(MCPeerID myPeerID) {
        super(null);
        this.initObject(this.init(myPeerID));
    }

    public MCSession(MCPeerID myPeerID, @Marshaler(value=NSArray.AsListMarshaler.class) List<SecIdentity> identity, MCEncryptionPreference encryptionPreference) {
        super(null);
        this.initObject(this.init(myPeerID, identity, encryptionPreference));
    }

    @Property(selector="delegate")
    public native MCSessionDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(MCSessionDelegate var1);

    @Property(selector="myPeerID")
    public native MCPeerID getMyPeerID();

    @Property(selector="securityIdentity")
    @Marshaler(value=NSArray.AsListMarshaler.class)
    public native List<SecIdentity> getSecurityIdentity();

    @Property(selector="encryptionPreference")
    public native MCEncryptionPreference getEncryptionPreference();

    @Property(selector="connectedPeers")
    public native NSArray<MCPeerID> getConnectedPeers();

    @GlobalValue(symbol="kMCSessionMinimumNumberOfPeers", optional=true)
    @MachineSizedUInt
    public static native long getMinimumNumberOfPeers();

    @GlobalValue(symbol="kMCSessionMaximumNumberOfPeers", optional=true)
    @MachineSizedUInt
    public static native long getMaximumNumberOfPeers();

    @Method(selector="initWithPeer:")
    @Pointer
    protected native long init(MCPeerID var1);

    @Method(selector="initWithPeer:securityIdentity:encryptionPreference:")
    @Pointer
    protected native long init(MCPeerID var1, @Marshaler(value=NSArray.AsListMarshaler.class) List<SecIdentity> var2, MCEncryptionPreference var3);

    public boolean sendData(NSData data, NSArray<MCPeerID> peerIDs, MCSessionSendDataMode mode) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.sendData(data, peerIDs, mode, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="sendData:toPeers:withMode:error:")
    private native boolean sendData(NSData var1, NSArray<MCPeerID> var2, MCSessionSendDataMode var3, NSError.NSErrorPtr var4);

    @Method(selector="disconnect")
    public native void disconnect();

    @Method(selector="sendResourceAtURL:withName:toPeer:withCompletionHandler:")
    public native NSProgress sendResource(NSURL var1, String var2, MCPeerID var3, @Block VoidBlock1<NSError> var4);

    public NSOutputStream startStream(String streamName, MCPeerID peerID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSOutputStream result = this.startStream(streamName, peerID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="startStreamWithName:toPeer:error:")
    private native NSOutputStream startStream(String var1, MCPeerID var2, NSError.NSErrorPtr var3);

    @Method(selector="nearbyConnectionDataForPeer:withCompletionHandler:")
    public native void requestNearbyConnectionData(MCPeerID var1, @Block VoidBlock2<NSData, NSError> var2);

    @Method(selector="connectPeer:withNearbyConnectionData:")
    public native void connectPeer(MCPeerID var1, NSData var2);

    @Method(selector="cancelConnectPeer:")
    public native void cancelConnectPeer(MCPeerID var1);

    static {
        ObjCRuntime.bind(MCSession.class);
    }

    public static class MCSessionPtr
    extends Ptr<MCSession, MCSessionPtr> {
    }
}

