/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.metal.MTLBuffer;
import org.robovm.apple.metal.MTLCommandEncoder;
import org.robovm.apple.metal.MTLCullMode;
import org.robovm.apple.metal.MTLDepthStencilState;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLIndexType;
import org.robovm.apple.metal.MTLPrimitiveType;
import org.robovm.apple.metal.MTLRenderPipelineState;
import org.robovm.apple.metal.MTLSamplerState;
import org.robovm.apple.metal.MTLScissorRect;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.metal.MTLTriangleFillMode;
import org.robovm.apple.metal.MTLViewport;
import org.robovm.apple.metal.MTLVisibilityResultMode;
import org.robovm.apple.metal.MTLWinding;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Metal")
public final class MTLRenderCommandEncoder
extends NSObject
implements MTLCommandEncoder {
    @Override
    @Property(selector="device")
    public native MTLDevice getDevice();

    @Override
    @Property(selector="label")
    public native String getLabel();

    @Override
    @Property(selector="setLabel:")
    public native void setLabel(String var1);

    public void setVertexBytes(byte[] bytes, @MachineSizedUInt long index) {
        this.setVertexBytes(VM.getArrayValuesAddress((Object)bytes), bytes.length, index);
    }

    public void setVertexBuffers(MTLBuffer[] buffers, long[] offsets, @ByVal NSRange range) {
        MTLBuffer.MTLBufferPtr bptr = new MTLBuffer.MTLBufferPtr();
        bptr.set((NativeObject[])buffers);
        MachineSizedUIntPtr lptr = new MachineSizedUIntPtr();
        lptr.set(offsets);
        this.setVertexBuffers(bptr, lptr, range);
    }

    public void setVertexTextures(MTLTexture[] textures, @ByVal NSRange range) {
        MTLTexture.MTLTexturePtr ptr = new MTLTexture.MTLTexturePtr();
        ptr.set((NativeObject[])textures);
        this.setVertexTextures(ptr, range);
    }

    public void setVertexSamplerStates(MTLSamplerState[] samplers, @ByVal NSRange range) {
        MTLSamplerState.MTLSamplerStatePtr ptr = new MTLSamplerState.MTLSamplerStatePtr();
        ptr.set((NativeObject[])samplers);
        this.setVertexSamplerStates(ptr, range);
    }

    public void setVertexSamplerStates(MTLSamplerState[] samplers, float[] lodMinClamps, float[] lodMaxClamps, @ByVal NSRange range) {
        MTLSamplerState.MTLSamplerStatePtr sptr = new MTLSamplerState.MTLSamplerStatePtr();
        sptr.set((NativeObject[])samplers);
        FloatPtr minptr = new FloatPtr();
        minptr.set(lodMinClamps);
        FloatPtr maxptr = new FloatPtr();
        maxptr.set(lodMaxClamps);
        this.setVertexSamplerStates(sptr, minptr, maxptr, range);
    }

    public void setFragmentBuffers(MTLBuffer[] buffers, long[] offsets, @ByVal NSRange range) {
        MTLBuffer.MTLBufferPtr bptr = new MTLBuffer.MTLBufferPtr();
        bptr.set((NativeObject[])buffers);
        MachineSizedUIntPtr lptr = new MachineSizedUIntPtr();
        lptr.set(offsets);
        this.setFragmentBuffers(bptr, lptr, range);
    }

    public void setFragmentTextures(MTLTexture[] textures, @ByVal NSRange range) {
        MTLTexture.MTLTexturePtr ptr = new MTLTexture.MTLTexturePtr();
        ptr.set((NativeObject[])textures);
        this.setFragmentTextures(ptr, range);
    }

    public void setFragmentSamplerStates(MTLSamplerState[] samplers, @ByVal NSRange range) {
        MTLSamplerState.MTLSamplerStatePtr ptr = new MTLSamplerState.MTLSamplerStatePtr();
        ptr.set((NativeObject[])samplers);
        this.setFragmentSamplerStates(ptr, range);
    }

    public void setFragmentSamplerStates(MTLSamplerState[] samplers, float[] lodMinClamps, float[] lodMaxClamps, @ByVal NSRange range) {
        MTLSamplerState.MTLSamplerStatePtr sptr = new MTLSamplerState.MTLSamplerStatePtr();
        sptr.set((NativeObject[])samplers);
        FloatPtr minptr = new FloatPtr();
        minptr.set(lodMinClamps);
        FloatPtr maxptr = new FloatPtr();
        maxptr.set(lodMaxClamps);
        this.setFragmentSamplerStates(sptr, minptr, maxptr, range);
    }

    @Method(selector="setRenderPipelineState:")
    public native void setRenderPipelineState(MTLRenderPipelineState var1);

    @Method(selector="setVertexBytes:length:atIndex:")
    protected native void setVertexBytes(@Pointer long var1, @MachineSizedUInt long var3, @MachineSizedUInt long var5);

    @Method(selector="setVertexBuffer:offset:atIndex:")
    public native void setVertexBuffer(MTLBuffer var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Method(selector="setVertexBufferOffset:atIndex:")
    public native void setVertexBufferOffset(@MachineSizedUInt long var1, @MachineSizedUInt long var3);

    @Method(selector="setVertexBuffers:offsets:withRange:")
    protected native void setVertexBuffers(MTLBuffer.MTLBufferPtr var1, MachineSizedUIntPtr var2, @ByVal NSRange var3);

    @Method(selector="setVertexTexture:atIndex:")
    public native void setVertexTexture(MTLTexture var1, @MachineSizedUInt long var2);

    @Method(selector="setVertexTextures:withRange:")
    protected native void setVertexTextures(MTLTexture.MTLTexturePtr var1, @ByVal NSRange var2);

    @Method(selector="setVertexSamplerState:atIndex:")
    public native void setVertexSamplerState(MTLSamplerState var1, @MachineSizedUInt long var2);

    @Method(selector="setVertexSamplerStates:withRange:")
    protected native void setVertexSamplerStates(MTLSamplerState.MTLSamplerStatePtr var1, @ByVal NSRange var2);

    @Method(selector="setVertexSamplerState:lodMinClamp:lodMaxClamp:atIndex:")
    public native void setVertexSamplerState(MTLSamplerState var1, float var2, float var3, @MachineSizedUInt long var4);

    @Method(selector="setVertexSamplerStates:lodMinClamps:lodMaxClamps:withRange:")
    protected native void setVertexSamplerStates(MTLSamplerState.MTLSamplerStatePtr var1, FloatPtr var2, FloatPtr var3, @ByVal NSRange var4);

    @Method(selector="setViewport:")
    public native void setViewport(@ByVal MTLViewport var1);

    @Method(selector="setFrontFacingWinding:")
    public native void setFrontFacingWinding(MTLWinding var1);

    @Method(selector="setCullMode:")
    public native void setCullMode(MTLCullMode var1);

    @Method(selector="setDepthBias:slopeScale:clamp:")
    public native void setDepthBias(float var1, float var2, float var3);

    @Method(selector="setScissorRect:")
    public native void setScissorRect(@ByVal MTLScissorRect var1);

    @Method(selector="setTriangleFillMode:")
    public native void setTriangleFillMode(MTLTriangleFillMode var1);

    @Method(selector="setFragmentBytes:length:atIndex:")
    public native void setFragmentBytes$length$atIndex$(VoidPtr var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Method(selector="setFragmentBuffer:offset:atIndex:")
    public native void setFragmentBuffer(MTLBuffer var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Method(selector="setFragmentBufferOffset:atIndex:")
    public native void setFragmentBufferOffset$atIndex$(@MachineSizedUInt long var1, @MachineSizedUInt long var3);

    @Method(selector="setFragmentBuffers:offsets:withRange:")
    protected native void setFragmentBuffers(MTLBuffer.MTLBufferPtr var1, MachineSizedUIntPtr var2, @ByVal NSRange var3);

    @Method(selector="setFragmentTexture:atIndex:")
    public native void setFragmentTexture(MTLTexture var1, @MachineSizedUInt long var2);

    @Method(selector="setFragmentTextures:withRange:")
    protected native void setFragmentTextures(MTLTexture.MTLTexturePtr var1, @ByVal NSRange var2);

    @Method(selector="setFragmentSamplerState:atIndex:")
    public native void setFragmentSamplerState(MTLSamplerState var1, @MachineSizedUInt long var2);

    @Method(selector="setFragmentSamplerStates:withRange:")
    protected native void setFragmentSamplerStates(MTLSamplerState.MTLSamplerStatePtr var1, @ByVal NSRange var2);

    @Method(selector="setFragmentSamplerState:lodMinClamp:lodMaxClamp:atIndex:")
    public native void setFragmentSamplerState(MTLSamplerState var1, float var2, float var3, @MachineSizedUInt long var4);

    @Method(selector="setFragmentSamplerStates:lodMinClamps:lodMaxClamps:withRange:")
    protected native void setFragmentSamplerStates(MTLSamplerState.MTLSamplerStatePtr var1, FloatPtr var2, FloatPtr var3, @ByVal NSRange var4);

    @Method(selector="setBlendColorRed:green:blue:alpha:")
    public native void setBlendColor(float var1, float var2, float var3, float var4);

    @Method(selector="setDepthStencilState:")
    public native void setDepthStencilState(MTLDepthStencilState var1);

    @Method(selector="setStencilReferenceValue:")
    public native void setStencilReferenceValue(int var1);

    @Method(selector="setVisibilityResultMode:offset:")
    public native void setVisibilityResultMode(MTLVisibilityResultMode var1, @MachineSizedUInt long var2);

    @Method(selector="drawPrimitives:vertexStart:vertexCount:instanceCount:")
    public native void drawPrimitives(MTLPrimitiveType var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6);

    @Method(selector="drawPrimitives:vertexStart:vertexCount:")
    public native void drawPrimitives(MTLPrimitiveType var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Method(selector="drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:instanceCount:")
    public native void drawIndexedPrimitives(MTLPrimitiveType var1, @MachineSizedUInt long var2, MTLIndexType var4, MTLBuffer var5, @MachineSizedUInt long var6, @MachineSizedUInt long var8);

    @Method(selector="drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:")
    public native void drawIndexedPrimitives(MTLPrimitiveType var1, @MachineSizedUInt long var2, MTLIndexType var4, MTLBuffer var5, @MachineSizedUInt long var6);

    @Override
    @Method(selector="endEncoding")
    public native void endEncoding();

    @Override
    @Method(selector="insertDebugSignpost:")
    public native void insertDebugSignpost(String var1);

    @Override
    @Method(selector="pushDebugGroup:")
    public native void pushDebugGroup(String var1);

    @Override
    @Method(selector="popDebugGroup")
    public native void popDebugGroup();

    static {
        ObjCRuntime.bind(MTLRenderCommandEncoder.class);
    }

    public static class MTLRenderCommandEncoderPtr
    extends Ptr<MTLRenderCommandEncoder, MTLRenderCommandEncoderPtr> {
    }
}

