/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.metal.MTLOrigin;
import org.robovm.apple.metal.MTLSize;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class MTLRegion
extends Struct<MTLRegion> {
    public MTLRegion() {
    }

    public MTLRegion(MTLOrigin origin, MTLSize size) {
        this.setOrigin(origin);
        this.setSize(size);
    }

    @StructMember(value=0)
    @ByVal
    public native MTLOrigin getOrigin();

    @StructMember(value=0)
    public native MTLRegion setOrigin(@ByVal MTLOrigin var1);

    @StructMember(value=1)
    @ByVal
    public native MTLSize getSize();

    @StructMember(value=1)
    public native MTLRegion setSize(@ByVal MTLSize var1);

    public static MTLRegion create1D(long x, long width) {
        MTLRegion region = new MTLRegion();
        region.setOrigin(new MTLOrigin(x, 0L, 0L));
        region.setSize(new MTLSize(width, 1L, 1L));
        return region;
    }

    public static MTLRegion create2D(long x, long y, long width, long height) {
        MTLRegion region = new MTLRegion();
        region.setOrigin(new MTLOrigin(x, y, 0L));
        region.setSize(new MTLSize(width, height, 1L));
        return region;
    }

    public static MTLRegion create3D(long x, long y, long z, long width, long height, long depth) {
        MTLRegion region = new MTLRegion();
        region.setOrigin(new MTLOrigin(x, y, z));
        region.setSize(new MTLSize(width, height, depth));
        return region;
    }

    public static class MTLRegionPtr
    extends Ptr<MTLRegion, MTLRegionPtr> {
    }
}

