/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.dispatch.DispatchData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.metal.MTLBuffer;
import org.robovm.apple.metal.MTLCommandQueue;
import org.robovm.apple.metal.MTLCompileOptions;
import org.robovm.apple.metal.MTLComputePipelineReflection;
import org.robovm.apple.metal.MTLComputePipelineState;
import org.robovm.apple.metal.MTLDepthStencilDescriptor;
import org.robovm.apple.metal.MTLDepthStencilState;
import org.robovm.apple.metal.MTLFeatureSet;
import org.robovm.apple.metal.MTLFunction;
import org.robovm.apple.metal.MTLLibrary;
import org.robovm.apple.metal.MTLPipelineOption;
import org.robovm.apple.metal.MTLRenderPipelineDescriptor;
import org.robovm.apple.metal.MTLRenderPipelineReflection;
import org.robovm.apple.metal.MTLRenderPipelineState;
import org.robovm.apple.metal.MTLResourceOptions;
import org.robovm.apple.metal.MTLSamplerDescriptor;
import org.robovm.apple.metal.MTLSamplerState;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.metal.MTLTextureDescriptor;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Metal")
public final class MTLDevice
extends NSObject
implements NSObjectProtocol {
    @Property(selector="name")
    public native String getName();

    public MTLBuffer newBuffer(byte[] bytes, MTLResourceOptions options) {
        return this.newBuffer(VM.getArrayValuesAddress((Object)bytes), bytes.length, options);
    }

    public MTLBuffer newBuffer(byte[] bytes, MTLResourceOptions options, final VoidBlock1<byte[]> deallocator) {
        return this.newBuffer(VM.getArrayValuesAddress((Object)bytes), bytes.length, options, new VoidBlock2<Long, Long>(){

            public void invoke(Long a, Long b) {
                byte[] bytes = VM.newByteArray((long)a, (int)b.intValue());
                deallocator.invoke((Object)bytes);
            }
        });
    }

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor, MTLPipelineOption options) throws NSErrorException {
        return this.newRenderPipelineState(descriptor, options, (MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr)null);
    }

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction, MTLPipelineOption options) throws NSErrorException {
        return this.newComputePipelineState(computeFunction, options, (MTLComputePipelineReflection.MTLComputePipelineReflectionPtr)null);
    }

    @Bridge(symbol="MTLCreateSystemDefaultDevice", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public static native MTLDevice getSystemDefaultDevice();

    @Method(selector="newCommandQueue")
    public native MTLCommandQueue newCommandQueue();

    @Method(selector="newCommandQueueWithMaxCommandBufferCount:")
    public native MTLCommandQueue newCommandQueue(@MachineSizedUInt long var1);

    @Method(selector="newBufferWithLength:options:")
    public native MTLBuffer newBuffer(@MachineSizedUInt long var1, MTLResourceOptions var3);

    @Method(selector="newBufferWithBytes:length:options:")
    protected native MTLBuffer newBuffer(@Pointer long var1, @MachineSizedUInt long var3, MTLResourceOptions var5);

    @Method(selector="newBufferWithBytesNoCopy:length:options:deallocator:")
    protected native MTLBuffer newBuffer(@Pointer long var1, @MachineSizedUInt long var3, MTLResourceOptions var5, @Block(value="(@Pointer,@MachineSizedUInt)") VoidBlock2<Long, Long> var6);

    @Method(selector="newDepthStencilStateWithDescriptor:")
    public native MTLDepthStencilState newDepthStencilState(MTLDepthStencilDescriptor var1);

    @Method(selector="newTextureWithDescriptor:")
    public native MTLTexture newTexture(MTLTextureDescriptor var1);

    @Method(selector="newSamplerStateWithDescriptor:")
    public native MTLSamplerState newSamplerState(MTLSamplerDescriptor var1);

    @Method(selector="newDefaultLibrary")
    public native MTLLibrary newDefaultLibrary();

    public MTLLibrary newLibraryWithFile(String filepath) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithFile(filepath, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithFile:error:")
    private native MTLLibrary newLibraryWithFile(String var1, NSError.NSErrorPtr var2);

    public MTLLibrary newLibraryWithData(DispatchData data) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithData(data, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithData:error:")
    private native MTLLibrary newLibraryWithData(DispatchData var1, NSError.NSErrorPtr var2);

    public MTLLibrary newLibraryWithSource(String source, MTLCompileOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithSource(source, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithSource:options:error:")
    private native MTLLibrary newLibraryWithSource(String var1, MTLCompileOptions var2, NSError.NSErrorPtr var3);

    @Method(selector="newLibraryWithSource:options:completionHandler:")
    public native void newLibraryWithSource(String var1, MTLCompileOptions var2, @Block VoidBlock2<MTLLibrary, NSError> var3);

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithDescriptor:error:")
    private native MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor var1, NSError.NSErrorPtr var2);

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor, MTLPipelineOption options, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithDescriptor:options:reflection:error:")
    private native MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor var1, MTLPipelineOption var2, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newRenderPipelineStateWithDescriptor:completionHandler:")
    public native void newRenderPipelineState(MTLRenderPipelineDescriptor var1, @Block VoidBlock2<MTLRenderPipelineState, NSError> var2);

    @Method(selector="newRenderPipelineStateWithDescriptor:options:completionHandler:")
    public native void newRenderPipelineState(MTLRenderPipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLRenderPipelineState, MTLRenderPipelineReflection, NSError> var3);

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(computeFunction, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithFunction:error:")
    private native MTLComputePipelineState newComputePipelineState(MTLFunction var1, NSError.NSErrorPtr var2);

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction, MTLPipelineOption options, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(computeFunction, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithFunction:options:reflection:error:")
    private native MTLComputePipelineState newComputePipelineState(MTLFunction var1, MTLPipelineOption var2, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newComputePipelineStateWithFunction:completionHandler:")
    public native void newComputePipelineState(MTLFunction var1, @Block VoidBlock2<MTLComputePipelineState, NSError> var2);

    @Method(selector="newComputePipelineStateWithFunction:options:completionHandler:")
    public native void newComputePipelineState(MTLFunction var1, MTLPipelineOption var2, @Block VoidBlock3<MTLComputePipelineState, MTLComputePipelineReflection, NSError> var3);

    @Method(selector="supportsFeatureSet:")
    public native boolean supportsFeatureSet(MTLFeatureSet var1);

    static {
        ObjCRuntime.bind(MTLDevice.class);
    }

    public static class MTLDevicePtr
    extends Ptr<MTLDevice, MTLDevicePtr> {
    }
}

