/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.metal.MTLBuffer;
import org.robovm.apple.metal.MTLCommandEncoder;
import org.robovm.apple.metal.MTLComputePipelineState;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLSamplerState;
import org.robovm.apple.metal.MTLSize;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Metal")
public final class MTLComputeCommandEncoder
extends NSObject
implements MTLCommandEncoder {
    @Override
    @Property(selector="device")
    public native MTLDevice getDevice();

    @Override
    @Property(selector="label")
    public native String getLabel();

    @Override
    @Property(selector="setLabel:")
    public native void setLabel(String var1);

    public void setBytes(byte[] bytes, long index) {
        this.setBytes(VM.getArrayValuesAddress((Object)bytes), bytes.length, index);
    }

    public void setBuffers(MTLBuffer[] buffers, long[] offsets, @ByVal NSRange range) {
        MTLBuffer.MTLBufferPtr bptr = new MTLBuffer.MTLBufferPtr();
        bptr.set((NativeObject[])buffers);
        MachineSizedUIntPtr lptr = new MachineSizedUIntPtr();
        lptr.set(offsets);
        this.setBuffers(bptr, lptr, range);
    }

    public void setTextures(MTLTexture[] textures, @ByVal NSRange range) {
        MTLTexture.MTLTexturePtr ptr = new MTLTexture.MTLTexturePtr();
        ptr.set((NativeObject[])textures);
        this.setTextures(ptr, range);
    }

    public void setSamplerStates(MTLSamplerState[] samplers, @ByVal NSRange range) {
        MTLSamplerState.MTLSamplerStatePtr ptr = new MTLSamplerState.MTLSamplerStatePtr();
        ptr.set((NativeObject[])samplers);
        this.setSamplerStates(ptr, range);
    }

    public void setSamplerStates(MTLSamplerState[] samplers, float[] lodMinClamps, float[] lodMaxClamps, @ByVal NSRange range) {
        MTLSamplerState.MTLSamplerStatePtr sptr = new MTLSamplerState.MTLSamplerStatePtr();
        sptr.set((NativeObject[])samplers);
        FloatPtr minptr = new FloatPtr();
        minptr.set(lodMinClamps);
        FloatPtr maxptr = new FloatPtr();
        maxptr.set(lodMaxClamps);
        this.setSamplerStates(sptr, minptr, maxptr, range);
    }

    @Method(selector="setComputePipelineState:")
    public native void setComputePipelineState(MTLComputePipelineState var1);

    @Method(selector="setBytes:length:atIndex:")
    protected native void setBytes(@Pointer long var1, @MachineSizedUInt long var3, @MachineSizedUInt long var5);

    @Method(selector="setBuffer:offset:atIndex:")
    public native void setBuffer(MTLBuffer var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Method(selector="setBufferOffset:atIndex:")
    public native void setBufferOffset(@MachineSizedUInt long var1, @MachineSizedUInt long var3);

    @Method(selector="setBuffers:offsets:withRange:")
    protected native void setBuffers(MTLBuffer.MTLBufferPtr var1, MachineSizedUIntPtr var2, @ByVal NSRange var3);

    @Method(selector="setTexture:atIndex:")
    public native void setTexture(MTLTexture var1, @MachineSizedUInt long var2);

    @Method(selector="setTextures:withRange:")
    protected native void setTextures(MTLTexture.MTLTexturePtr var1, @ByVal NSRange var2);

    @Method(selector="setSamplerState:atIndex:")
    public native void setSamplerState(MTLSamplerState var1, @MachineSizedUInt long var2);

    @Method(selector="setSamplerStates:withRange:")
    protected native void setSamplerStates(MTLSamplerState.MTLSamplerStatePtr var1, @ByVal NSRange var2);

    @Method(selector="setSamplerState:lodMinClamp:lodMaxClamp:atIndex:")
    public native void setSamplerState(MTLSamplerState var1, float var2, float var3, @MachineSizedUInt long var4);

    @Method(selector="setSamplerStates:lodMinClamps:lodMaxClamps:withRange:")
    protected native void setSamplerStates(MTLSamplerState.MTLSamplerStatePtr var1, FloatPtr var2, FloatPtr var3, @ByVal NSRange var4);

    @Method(selector="setThreadgroupMemoryLength:atIndex:")
    public native void setThreadgroupMemoryLength(@MachineSizedUInt long var1, @MachineSizedUInt long var3);

    @Method(selector="dispatchThreadgroups:threadsPerThreadgroup:")
    public native void dispatchThreadgroups(@ByVal MTLSize var1, @ByVal MTLSize var2);

    @Override
    @Method(selector="endEncoding")
    public native void endEncoding();

    @Override
    @Method(selector="insertDebugSignpost:")
    public native void insertDebugSignpost(String var1);

    @Override
    @Method(selector="pushDebugGroup:")
    public native void pushDebugGroup(String var1);

    @Override
    @Method(selector="popDebugGroup")
    public native void popDebugGroup();

    static {
        ObjCRuntime.bind(MTLComputeCommandEncoder.class);
    }

    public static class MTLComputeCommandEncoderPtr
    extends Ptr<MTLComputeCommandEncoder, MTLComputeCommandEncoderPtr> {
    }
}

