/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import java.util.HashSet;
import java.util.Set;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.mediaplayer.MPRemoteCommandEvent;
import org.robovm.apple.mediaplayer.MPRemoteCommandHandlerStatus;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block1;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MediaPlayer")
@NativeClass
public class MPRemoteCommand
extends NSObject {
    private Set<ListenerWrapper> listeners = new HashSet<ListenerWrapper>();
    private static final Selector handleCommand;

    public MPRemoteCommand() {
    }

    protected MPRemoteCommand(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="isEnabled")
    public native boolean isEnabled();

    @Property(selector="setEnabled:")
    public native void setEnabled(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(OnCommandListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ListenerWrapper wrapper = new ListenerWrapper(listener);
        this.addTarget(wrapper, handleCommand);
        this.addStrongRef(wrapper);
        Set<ListenerWrapper> set = this.listeners;
        synchronized (set) {
            this.listeners.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(OnCommandListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Set<ListenerWrapper> set = this.listeners;
        synchronized (set) {
            ListenerWrapper l = null;
            for (ListenerWrapper wrapper : this.listeners) {
                if (wrapper.listener != listener) continue;
                this.removeTarget(wrapper, handleCommand);
                l = wrapper;
                break;
            }
            if (l != null) {
                this.listeners.remove(l);
                this.removeStrongRef(l);
            }
        }
    }

    @Method(selector="addTarget:action:")
    public native void addTarget(NSObject var1, Selector var2);

    @Method(selector="removeTarget:action:")
    public native void removeTarget(NSObject var1, Selector var2);

    @Method(selector="removeTarget:")
    public native void removeTarget(NSObject var1);

    @Method(selector="addTargetWithHandler:")
    public native NSObject addTarget(@Block Block1<MPRemoteCommandEvent, MPRemoteCommandHandlerStatus> var1);

    static {
        ObjCRuntime.bind(MPRemoteCommand.class);
        handleCommand = Selector.register((String)"handleCommand");
    }

    private static class ListenerWrapper
    extends NSObject {
        private final OnCommandListener listener;

        private ListenerWrapper(OnCommandListener listener) {
            this.listener = listener;
        }

        @Method(selector="handleCommand")
        private void handleCommand(MPRemoteCommandEvent event) {
            this.listener.onCommand(event);
        }
    }

    public static interface OnCommandListener {
        public void onCommand(MPRemoteCommandEvent var1);
    }

    public static class MPRemoteCommandPtr
    extends Ptr<MPRemoteCommand, MPRemoteCommandPtr> {
    }
}

