/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.mediaplayer.MPMediaItemArtwork;
import org.robovm.apple.mediaplayer.MPMediaItemProperty;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="MediaPlayer")
public class MPNowPlayingInfo
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    public MPNowPlayingInfo() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    protected MPNowPlayingInfo(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public long getPersistentID() {
        if (this.data.containsKey(MPMediaItemProperty.ItemPersistentIDValue())) {
            NSNumber val = (NSNumber)this.data.get(MPMediaItemProperty.ItemPersistentIDValue());
            return val.longValue();
        }
        return 0L;
    }

    public MPNowPlayingInfo setPersistentID(long id) {
        this.data.put(MPMediaItemProperty.ItemPersistentIDValue(), NSNumber.valueOf(id));
        return this;
    }

    public String getTitle() {
        if (this.data.containsKey(MPMediaItemProperty.TitleValue())) {
            NSString val = (NSString)this.data.get(MPMediaItemProperty.TitleValue());
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setTitle(String title) {
        this.data.put(MPMediaItemProperty.TitleValue(), new NSString(title));
        return this;
    }

    public String getAlbumTitle() {
        if (this.data.containsKey(MPMediaItemProperty.AlbumTitleValue())) {
            NSString val = (NSString)this.data.get(MPMediaItemProperty.AlbumTitleValue());
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setAlbumTitle(String albumTitle) {
        this.data.put(MPMediaItemProperty.AlbumTitleValue(), new NSString(albumTitle));
        return this;
    }

    public String getArtist() {
        if (this.data.containsKey(MPMediaItemProperty.ArtistValue())) {
            NSString val = (NSString)this.data.get(MPMediaItemProperty.ArtistValue());
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setArtist(String artist) {
        this.data.put(MPMediaItemProperty.ArtistValue(), new NSString(artist));
        return this;
    }

    public String getGenre() {
        if (this.data.containsKey(MPMediaItemProperty.GenreValue())) {
            NSString val = (NSString)this.data.get(MPMediaItemProperty.GenreValue());
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setGenre(String genre) {
        this.data.put(MPMediaItemProperty.GenreValue(), new NSString(genre));
        return this;
    }

    public String getComposer() {
        if (this.data.containsKey(MPMediaItemProperty.ComposerValue())) {
            NSString val = (NSString)this.data.get(MPMediaItemProperty.ComposerValue());
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setComposer(String composer) {
        this.data.put(MPMediaItemProperty.ComposerValue(), new NSString(composer));
        return this;
    }

    public double getPlaybackDuration() {
        if (this.data.containsKey(MPMediaItemProperty.PlaybackDurationValue())) {
            NSNumber val = (NSNumber)this.data.get(MPMediaItemProperty.PlaybackDurationValue());
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setPlaybackDuration(double playbackDuration) {
        this.data.put(MPMediaItemProperty.PlaybackDurationValue(), NSNumber.valueOf(playbackDuration));
        return this;
    }

    public int getAlbumTrackNumber() {
        if (this.data.containsKey(MPMediaItemProperty.AlbumTrackNumberValue())) {
            NSNumber val = (NSNumber)this.data.get(MPMediaItemProperty.AlbumTrackNumberValue());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setAlbumTrackNumber(int albumTrackNumber) {
        this.data.put(MPMediaItemProperty.AlbumTrackNumberValue(), NSNumber.valueOf(albumTrackNumber));
        return this;
    }

    public int getAlbumTrackCount() {
        if (this.data.containsKey(MPMediaItemProperty.AlbumTrackCountValue())) {
            NSNumber val = (NSNumber)this.data.get(MPMediaItemProperty.AlbumTrackCountValue());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setAlbumTrackCount(int albumTrackCount) {
        this.data.put(MPMediaItemProperty.AlbumTrackCountValue(), NSNumber.valueOf(albumTrackCount));
        return this;
    }

    public int getDiscNumber() {
        if (this.data.containsKey(MPMediaItemProperty.DiscNumberValue())) {
            NSNumber val = (NSNumber)this.data.get(MPMediaItemProperty.DiscNumberValue());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setDiscNumber(int discNumber) {
        this.data.put(MPMediaItemProperty.DiscNumberValue(), NSNumber.valueOf(discNumber));
        return this;
    }

    public int getDiscCount() {
        if (this.data.containsKey(MPMediaItemProperty.DiscCountValue())) {
            NSNumber val = (NSNumber)this.data.get(MPMediaItemProperty.DiscCountValue());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setDiscCount(int discCount) {
        this.data.put(MPMediaItemProperty.DiscCountValue(), NSNumber.valueOf(discCount));
        return this;
    }

    public MPMediaItemArtwork getArtwork() {
        if (this.data.containsKey(MPMediaItemProperty.ArtworkValue())) {
            MPMediaItemArtwork val = (MPMediaItemArtwork)this.data.get(MPMediaItemProperty.ArtworkValue());
            return val;
        }
        return null;
    }

    public MPNowPlayingInfo setArtwork(MPMediaItemArtwork artwork) {
        this.data.put(MPMediaItemProperty.ArtworkValue(), artwork);
        return this;
    }

    public double getElapsedPlaybackTime() {
        if (this.data.containsKey(MPNowPlayingInfo.ElapsedPlaybackTime())) {
            NSNumber val = (NSNumber)this.data.get(MPNowPlayingInfo.ElapsedPlaybackTime());
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setElapsedPlaybackTime(double elapsedPlaybackTime) {
        this.data.put(MPNowPlayingInfo.ElapsedPlaybackTime(), NSNumber.valueOf(elapsedPlaybackTime));
        return this;
    }

    public double getPlaybackRate() {
        if (this.data.containsKey(MPNowPlayingInfo.PlaybackRate())) {
            NSNumber val = (NSNumber)this.data.get(MPNowPlayingInfo.PlaybackRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setPlaybackRate(double playbackRate) {
        this.data.put(MPNowPlayingInfo.PlaybackRate(), NSNumber.valueOf(playbackRate));
        return this;
    }

    public int getPlaybackQueueIndex() {
        if (this.data.containsKey(MPNowPlayingInfo.PlaybackQueueIndex())) {
            NSNumber val = (NSNumber)this.data.get(MPNowPlayingInfo.PlaybackQueueIndex());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setPlaybackQueueIndex(int playbackQueueIndex) {
        this.data.put(MPNowPlayingInfo.PlaybackQueueIndex(), NSNumber.valueOf(playbackQueueIndex));
        return this;
    }

    public int getPlaybackQueueCount() {
        if (this.data.containsKey(MPNowPlayingInfo.PlaybackQueueCount())) {
            NSNumber val = (NSNumber)this.data.get(MPNowPlayingInfo.PlaybackQueueCount());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setPlaybackQueueCount(int playbackQueueCount) {
        this.data.put(MPNowPlayingInfo.PlaybackQueueCount(), NSNumber.valueOf(playbackQueueCount));
        return this;
    }

    public int getChapterNumber() {
        if (this.data.containsKey(MPNowPlayingInfo.ChapterNumber())) {
            NSNumber val = (NSNumber)this.data.get(MPNowPlayingInfo.ChapterNumber());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setChapterNumber(int chapterNumber) {
        this.data.put(MPNowPlayingInfo.ChapterNumber(), NSNumber.valueOf(chapterNumber));
        return this;
    }

    public int getChapterCount() {
        if (this.data.containsKey(MPNowPlayingInfo.ChapterCount())) {
            NSNumber val = (NSNumber)this.data.get(MPNowPlayingInfo.ChapterCount());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setChapterCount(int chapterCount) {
        this.data.put(MPNowPlayingInfo.ChapterCount(), NSNumber.valueOf(chapterCount));
        return this;
    }

    public double getDefaultPlaybackRate() {
        if (this.data.containsKey(MPNowPlayingInfo.DefaultPlaybackRate())) {
            NSNumber val = (NSNumber)this.data.get(MPNowPlayingInfo.DefaultPlaybackRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setDefaultPlaybackRate(double playbackRate) {
        this.data.put(MPNowPlayingInfo.DefaultPlaybackRate(), NSNumber.valueOf(playbackRate));
        return this;
    }

    @GlobalValue(symbol="MPNowPlayingInfoPropertyElapsedPlaybackTime", optional=true)
    protected static native NSString ElapsedPlaybackTime();

    @GlobalValue(symbol="MPNowPlayingInfoPropertyPlaybackRate", optional=true)
    protected static native NSString PlaybackRate();

    @GlobalValue(symbol="MPNowPlayingInfoPropertyDefaultPlaybackRate", optional=true)
    protected static native NSString DefaultPlaybackRate();

    @GlobalValue(symbol="MPNowPlayingInfoPropertyPlaybackQueueIndex", optional=true)
    protected static native NSString PlaybackQueueIndex();

    @GlobalValue(symbol="MPNowPlayingInfoPropertyPlaybackQueueCount", optional=true)
    protected static native NSString PlaybackQueueCount();

    @GlobalValue(symbol="MPNowPlayingInfoPropertyChapterNumber", optional=true)
    protected static native NSString ChapterNumber();

    @GlobalValue(symbol="MPNowPlayingInfoPropertyChapterCount", optional=true)
    protected static native NSString ChapterCount();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(MPNowPlayingInfo.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static MPNowPlayingInfo toObject(Class<MPNowPlayingInfo> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new MPNowPlayingInfo(o);
        }

        @MarshalsPointer
        public static long toNative(MPNowPlayingInfo o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

