/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIImage;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="MediaPlayer")
public class MPMoviePlayerThumbnailRequest
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected MPMoviePlayerThumbnailRequest(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public UIImage getImage() {
        if (this.data.containsKey(MPMoviePlayerThumbnailRequest.ImageKey())) {
            UIImage val = (UIImage)this.data.get(MPMoviePlayerThumbnailRequest.ImageKey());
            return val;
        }
        return null;
    }

    public double getTime() {
        if (this.data.containsKey(MPMoviePlayerThumbnailRequest.TimeKey())) {
            NSNumber val = (NSNumber)this.data.get(MPMoviePlayerThumbnailRequest.TimeKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSError getError() {
        if (this.data.containsKey(MPMoviePlayerThumbnailRequest.ErrorKey())) {
            NSError val = (NSError)this.data.get(MPMoviePlayerThumbnailRequest.ErrorKey());
            return val;
        }
        return null;
    }

    @GlobalValue(symbol="MPMoviePlayerThumbnailImageKey", optional=true)
    protected static native NSString ImageKey();

    @GlobalValue(symbol="MPMoviePlayerThumbnailTimeKey", optional=true)
    protected static native NSString TimeKey();

    @GlobalValue(symbol="MPMoviePlayerThumbnailErrorKey", optional=true)
    protected static native NSString ErrorKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(MPMoviePlayerThumbnailRequest.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static MPMoviePlayerThumbnailRequest toObject(Class<MPMoviePlayerThumbnailRequest> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new MPMoviePlayerThumbnailRequest(o);
        }

        @MarshalsPointer
        public static long toNative(MPMoviePlayerThumbnailRequest o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

