/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.iad.MPMoviePlayerControllerExtensions;
import org.robovm.apple.mediaplayer.MPMediaPlayback;
import org.robovm.apple.mediaplayer.MPMovieAccessLog;
import org.robovm.apple.mediaplayer.MPMovieControlStyle;
import org.robovm.apple.mediaplayer.MPMovieErrorLog;
import org.robovm.apple.mediaplayer.MPMovieFinishReason;
import org.robovm.apple.mediaplayer.MPMovieLoadState;
import org.robovm.apple.mediaplayer.MPMovieMediaTypeMask;
import org.robovm.apple.mediaplayer.MPMoviePlaybackState;
import org.robovm.apple.mediaplayer.MPMoviePlayerFullscreenAnimation;
import org.robovm.apple.mediaplayer.MPMoviePlayerThumbnailRequest;
import org.robovm.apple.mediaplayer.MPMovieRepeatMode;
import org.robovm.apple.mediaplayer.MPMovieScalingMode;
import org.robovm.apple.mediaplayer.MPMovieSourceType;
import org.robovm.apple.mediaplayer.MPMovieTimeOption;
import org.robovm.apple.mediaplayer.MPTimedMetadata;
import org.robovm.apple.uikit.UIImage;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MediaPlayer")
@NativeClass
public class MPMoviePlayerController
extends NSObject
implements MPMediaPlayback {
    public MPMoviePlayerController() {
    }

    protected MPMoviePlayerController(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MPMoviePlayerController(NSURL url) {
        super(null);
        this.initObject(this.init(url));
    }

    @Property(selector="contentURL")
    public native NSURL getContentURL();

    @Property(selector="setContentURL:")
    public native void setContentURL(NSURL var1);

    @Property(selector="view")
    public native UIView getView();

    @Property(selector="backgroundView")
    public native UIView getBackgroundView();

    @Property(selector="playbackState")
    public native MPMoviePlaybackState getPlaybackState();

    @Property(selector="loadState")
    public native MPMovieLoadState getLoadState();

    @Property(selector="controlStyle")
    public native MPMovieControlStyle getControlStyle();

    @Property(selector="setControlStyle:")
    public native void setControlStyle(MPMovieControlStyle var1);

    @Property(selector="repeatMode")
    public native MPMovieRepeatMode getRepeatMode();

    @Property(selector="setRepeatMode:")
    public native void setRepeatMode(MPMovieRepeatMode var1);

    @Property(selector="shouldAutoplay")
    public native boolean shouldAutoplay();

    @Property(selector="setShouldAutoplay:")
    public native void setShouldAutoplay(boolean var1);

    @Property(selector="isFullscreen")
    public native boolean isFullscreen();

    @Property(selector="setFullscreen:")
    public native void setFullscreen(boolean var1);

    @Property(selector="scalingMode")
    public native MPMovieScalingMode getScalingMode();

    @Property(selector="setScalingMode:")
    public native void setScalingMode(MPMovieScalingMode var1);

    @Property(selector="readyForDisplay")
    public native boolean isReadyForDisplay();

    @Property(selector="movieMediaTypes")
    public native MPMovieMediaTypeMask getMovieMediaTypes();

    @Property(selector="movieSourceType")
    public native MPMovieSourceType getMovieSourceType();

    @Property(selector="setMovieSourceType:")
    public native void setMovieSourceType(MPMovieSourceType var1);

    @Property(selector="duration")
    public native double getDuration();

    @Property(selector="playableDuration")
    public native double getPlayableDuration();

    @Property(selector="naturalSize")
    @ByVal
    public native CGSize getNaturalSize();

    @Property(selector="initialPlaybackTime")
    public native double getInitialPlaybackTime();

    @Property(selector="setInitialPlaybackTime:")
    public native void setInitialPlaybackTime(double var1);

    @Property(selector="endPlaybackTime")
    public native double getEndPlaybackTime();

    @Property(selector="setEndPlaybackTime:")
    public native void setEndPlaybackTime(double var1);

    @Property(selector="allowsAirPlay")
    public native boolean allowsAirPlay();

    @Property(selector="setAllowsAirPlay:")
    public native void setAllowsAirPlay(boolean var1);

    @Property(selector="isAirPlayVideoActive")
    public native boolean isAirPlayVideoActive();

    @Property(selector="timedMetadata")
    public native NSArray<MPTimedMetadata> getTimedMetadata();

    @Property(selector="accessLog")
    public native MPMovieAccessLog getAccessLog();

    @Property(selector="errorLog")
    public native MPMovieErrorLog getErrorLog();

    @Deprecated
    @Property(selector="useApplicationAudioSession")
    public native boolean usesApplicationAudioSession();

    @Deprecated
    @Property(selector="setUseApplicationAudioSession:")
    public native void setUsesApplicationAudioSession(boolean var1);

    @Override
    @Property(selector="isPreparedToPlay")
    public native boolean isPreparedToPlay();

    @Override
    @Property(selector="currentPlaybackTime")
    public native double getCurrentPlaybackTime();

    @Override
    @Property(selector="setCurrentPlaybackTime:")
    public native void setCurrentPlaybackTime(double var1);

    @Override
    @Property(selector="currentPlaybackRate")
    public native float getCurrentPlaybackRate();

    @Override
    @Property(selector="setCurrentPlaybackRate:")
    public native void setCurrentPlaybackRate(float var1);

    @WeaklyLinked
    public void playPrerollAd(@Block VoidBlock1<NSError> completionHandler) {
        MPMoviePlayerControllerExtensions.playPrerollAd(this, completionHandler);
    }

    @WeaklyLinked
    public static void preparePrerollAds() {
        MPMoviePlayerControllerExtensions.preparePrerollAds();
    }

    @WeaklyLinked
    public void cancelPreroll() {
        MPMoviePlayerControllerExtensions.cancelPreroll(this);
    }

    @GlobalValue(symbol="MPMediaPlaybackIsPreparedToPlayDidChangeNotification", optional=true)
    public static native NSString IsPreparedToPlayDidChangeNotification();

    @GlobalValue(symbol="MPMoviePlayerScalingModeDidChangeNotification", optional=true)
    public static native NSString ScalingModeDidChangeNotification();

    @GlobalValue(symbol="MPMoviePlayerPlaybackDidFinishNotification", optional=true)
    public static native NSString PlaybackDidFinishNotification();

    @GlobalValue(symbol="MPMoviePlayerPlaybackDidFinishReasonUserInfoKey", optional=true)
    protected static native NSString PlaybackDidFinishReasonUserInfoKey();

    @GlobalValue(symbol="MPMoviePlayerPlaybackStateDidChangeNotification", optional=true)
    public static native NSString PlaybackStateDidChangeNotification();

    @GlobalValue(symbol="MPMoviePlayerLoadStateDidChangeNotification", optional=true)
    public static native NSString LoadStateDidChangeNotification();

    @GlobalValue(symbol="MPMoviePlayerNowPlayingMovieDidChangeNotification", optional=true)
    public static native NSString NowPlayingMovieDidChangeNotification();

    @GlobalValue(symbol="MPMoviePlayerWillEnterFullscreenNotification", optional=true)
    public static native NSString WillEnterFullscreenNotification();

    @GlobalValue(symbol="MPMoviePlayerDidEnterFullscreenNotification", optional=true)
    public static native NSString DidEnterFullscreenNotification();

    @GlobalValue(symbol="MPMoviePlayerWillExitFullscreenNotification", optional=true)
    public static native NSString WillExitFullscreenNotification();

    @GlobalValue(symbol="MPMoviePlayerDidExitFullscreenNotification", optional=true)
    public static native NSString DidExitFullscreenNotification();

    @GlobalValue(symbol="MPMoviePlayerIsAirPlayVideoActiveDidChangeNotification", optional=true)
    public static native NSString IsAirPlayVideoActiveDidChangeNotification();

    @GlobalValue(symbol="MPMoviePlayerReadyForDisplayDidChangeNotification", optional=true)
    public static native NSString ReadyForDisplayDidChangeNotification();

    @GlobalValue(symbol="MPMovieMediaTypesAvailableNotification", optional=true)
    public static native NSString MediaTypesAvailableNotification();

    @GlobalValue(symbol="MPMovieSourceTypeAvailableNotification", optional=true)
    public static native NSString SourceTypeAvailableNotification();

    @GlobalValue(symbol="MPMovieDurationAvailableNotification", optional=true)
    public static native NSString DurationAvailableNotification();

    @GlobalValue(symbol="MPMovieNaturalSizeAvailableNotification", optional=true)
    public static native NSString NaturalSizeAvailableNotification();

    @GlobalValue(symbol="MPMoviePlayerThumbnailImageRequestDidFinishNotification", optional=true)
    public static native NSString ThumbnailImageRequestDidFinishNotification();

    @GlobalValue(symbol="MPMoviePlayerTimedMetadataUpdatedNotification", optional=true)
    public static native NSString TimedMetadataUpdatedNotification();

    @GlobalValue(symbol="MPMoviePlayerTimedMetadataUserInfoKey", optional=true)
    protected static native NSString TimedMetadataUserInfoKey();

    @Method(selector="initWithContentURL:")
    @Pointer
    protected native long init(NSURL var1);

    @Method(selector="setFullscreen:animated:")
    public native void setFullscreen(boolean var1, boolean var2);

    @Deprecated
    @Method(selector="thumbnailImageAtTime:timeOption:")
    public native UIImage getThumbnailImage(double var1, MPMovieTimeOption var3);

    @Method(selector="requestThumbnailImagesAtTimes:timeOption:")
    public native void requestThumbnailImages(NSArray<NSNumber> var1, MPMovieTimeOption var2);

    @Method(selector="cancelAllThumbnailImageRequests")
    public native void cancelAllThumbnailImageRequests();

    @Override
    @Method(selector="prepareToPlay")
    public native void prepareToPlay();

    @Override
    @Method(selector="play")
    public native void play();

    @Override
    @Method(selector="pause")
    public native void pause();

    @Override
    @Method(selector="stop")
    public native void stop();

    @Override
    @Method(selector="beginSeekingForward")
    public native void beginSeekingForward();

    @Override
    @Method(selector="beginSeekingBackward")
    public native void beginSeekingBackward();

    @Override
    @Method(selector="endSeeking")
    public native void endSeeking();

    static {
        ObjCRuntime.bind(MPMoviePlayerController.class);
    }

    public static class MPMoviePlayerControllerPtr
    extends Ptr<MPMoviePlayerController, MPMoviePlayerControllerPtr> {
    }

    public static class Notifications {
        public static NSObject observeIsPreparedToPlayDidChange(MPMoviePlayerController object, final VoidBlock1<MPMediaPlayback> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.IsPreparedToPlayDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMediaPlayback)((Object)a.getObject())));
                }
            });
        }

        public static NSObject observeDurationAvailable(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.DurationAvailableNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeMediaTypesAvailable(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.MediaTypesAvailableNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeNaturalSizeAvailable(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.NaturalSizeAvailableNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeDidEnterFullscreen(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.DidEnterFullscreenNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeDidExitFullscreen(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.DidExitFullscreenNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeIsAirPlayVideoActiveDidChange(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.IsAirPlayVideoActiveDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeLoadStateDidChange(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.LoadStateDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeNowPlayingMovieDidChange(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.NowPlayingMovieDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observePlaybackDidFinish(MPMoviePlayerController object, final VoidBlock3<MPMoviePlayerController, MPMovieFinishReason, NSError> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.PlaybackDidFinishNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<NSString, NSObject> data = a.getUserInfo();
                    NSNumber val = (NSNumber)data.get(MPMoviePlayerController.PlaybackDidFinishReasonUserInfoKey());
                    NSError error = (NSError)data.get(new NSString("error"));
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()), (Object)MPMovieFinishReason.valueOf(val.intValue()), (Object)error);
                }
            });
        }

        public static NSObject observePlaybackStateDidChange(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.PlaybackStateDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeScalingModeDidChange(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.ScalingModeDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeThumbnailImageRequestDidFinish(MPMoviePlayerController object, final VoidBlock2<MPMoviePlayerController, MPMoviePlayerThumbnailRequest> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.ThumbnailImageRequestDidFinishNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()), (Object)new MPMoviePlayerThumbnailRequest(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeWillEnterFullscreen(MPMoviePlayerController object, final VoidBlock2<MPMoviePlayerController, MPMoviePlayerFullscreenAnimation> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.WillEnterFullscreenNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()), (Object)new MPMoviePlayerFullscreenAnimation(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeWillExitFullscreen(MPMoviePlayerController object, final VoidBlock2<MPMoviePlayerController, MPMoviePlayerFullscreenAnimation> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.WillExitFullscreenNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()), (Object)new MPMoviePlayerFullscreenAnimation(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeNewSourceTypeAvailable(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.SourceTypeAvailableNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeReadyForDisplayDidChange(MPMoviePlayerController object, final VoidBlock1<MPMoviePlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.ReadyForDisplayDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeTimedMetadataUpdated(MPMoviePlayerController object, final VoidBlock2<MPMoviePlayerController, NSArray<MPTimedMetadata>> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMoviePlayerController.TimedMetadataUpdatedNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<NSString, NSObject> userInfo = a.getUserInfo();
                    NSArray arr = (NSArray)userInfo.get(MPMoviePlayerController.TimedMetadataUserInfoKey());
                    block.invoke((Object)((MPMoviePlayerController)a.getObject()), (Object)arr);
                }
            });
        }
    }
}

