/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.mediaplayer.MPMediaItemProperty;
import org.robovm.apple.mediaplayer.MPMediaPlaylistProperty;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="MediaPlayer")
public class MPMediaEntityProperty
extends CocoaUtility {
    public static final MPMediaEntityProperty EntityPersistentID;
    private static MPMediaEntityProperty[] values;
    final LazyGlobalValue<NSString> lazyGlobalValue;
    boolean filterable;

    protected MPMediaEntityProperty(String getterName, boolean filterable) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
        this.filterable = filterable;
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public static MPMediaEntityProperty valueOf(NSString value) {
        for (MPMediaEntityProperty v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        MPMediaItemProperty item = MPMediaItemProperty.findValue(value);
        if (item != null) {
            return item;
        }
        MPMediaPlaylistProperty playlist = MPMediaPlaylistProperty.findValue(value);
        if (playlist != null) {
            return playlist;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + MPMediaEntityProperty.class.getName());
    }

    @GlobalValue(symbol="MPMediaEntityPropertyPersistentID", optional=true)
    protected static native NSString EntityPersistentIDValue();

    static {
        Bro.bind(MPMediaEntityProperty.class);
        EntityPersistentID = new MPMediaEntityProperty("EntityPersistentIDValue", true);
        values = new MPMediaEntityProperty[]{EntityPersistentID};
    }

    public static class Marshaler {
        @MarshalsPointer
        public static MPMediaEntityProperty toObject(Class<MPMediaEntityProperty> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return MPMediaEntityProperty.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(MPMediaEntityProperty o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

