/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mapkit;

import org.robovm.apple.corelocation.CLLocationCoordinate2D;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.mapkit.MKMapPoint;
import org.robovm.apple.mapkit.MKMapRect;
import org.robovm.apple.mapkit.MKMultiPoint;
import org.robovm.apple.mapkit.MKOverlay;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MapKit")
@NativeClass
public class MKPolygon
extends MKMultiPoint
implements MKOverlay {
    public MKPolygon() {
    }

    protected MKPolygon(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="interiorPolygons")
    public native NSArray<MKPolygon> getInteriorPolygons();

    @Override
    @Property(selector="coordinate")
    @ByVal
    public native CLLocationCoordinate2D getCoordinate();

    @Override
    @Property(selector="boundingMapRect")
    @ByVal
    public native MKMapRect getBoundingMapRect();

    public static MKPolygon create(MKMapPoint[] points) {
        MKMapPoint first = (MKMapPoint)Struct.allocate(MKMapPoint.class, (int)points.length);
        first.update(points);
        return MKPolygon.create(first, (long)points.length);
    }

    public static MKPolygon create(MKMapPoint[] points, NSArray<MKPolygon> interiorPolygons) {
        MKMapPoint first = (MKMapPoint)Struct.allocate(MKMapPoint.class, (int)points.length);
        first.update(points);
        return MKPolygon.create(first, (long)points.length, interiorPolygons);
    }

    public static MKPolygon create(CLLocationCoordinate2D[] coords) {
        CLLocationCoordinate2D first = (CLLocationCoordinate2D)Struct.allocate(CLLocationCoordinate2D.class, (int)coords.length);
        first.update(coords);
        return MKPolygon.create(first, (long)coords.length);
    }

    public static MKPolygon create(CLLocationCoordinate2D[] coords, NSArray<MKPolygon> interiorPolygons) {
        CLLocationCoordinate2D first = (CLLocationCoordinate2D)Struct.allocate(CLLocationCoordinate2D.class, (int)coords.length);
        first.update(coords);
        return MKPolygon.create(first, (long)coords.length, interiorPolygons);
    }

    @Method(selector="polygonWithPoints:count:")
    private static native MKPolygon create(MKMapPoint var0, @MachineSizedUInt long var1);

    @Method(selector="polygonWithPoints:count:interiorPolygons:")
    private static native MKPolygon create(MKMapPoint var0, @MachineSizedUInt long var1, NSArray<MKPolygon> var3);

    @Method(selector="polygonWithCoordinates:count:")
    private static native MKPolygon create(CLLocationCoordinate2D var0, @MachineSizedUInt long var1);

    @Method(selector="polygonWithCoordinates:count:interiorPolygons:")
    private static native MKPolygon create(CLLocationCoordinate2D var0, @MachineSizedUInt long var1, NSArray<MKPolygon> var3);

    @Override
    @Method(selector="intersectsMapRect:")
    public native boolean intersects(@ByVal MKMapRect var1);

    @Override
    @Method(selector="canReplaceMapContent")
    public native boolean canReplaceMapContent();

    static {
        ObjCRuntime.bind(MKPolygon.class);
    }

    public static class MKPolygonPtr
    extends Ptr<MKPolygon, MKPolygonPtr> {
    }
}

