/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mapkit;

import org.robovm.apple.corelocation.CLLocationCoordinate2D;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MapKit")
public class MKMapPoint
extends Struct<MKMapPoint> {
    public MKMapPoint() {
    }

    public MKMapPoint(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    @StructMember(value=0)
    public native double getX();

    @StructMember(value=0)
    public native MKMapPoint setX(double var1);

    @StructMember(value=1)
    public native double getY();

    @StructMember(value=1)
    public native MKMapPoint setY(double var1);

    public boolean equalsTo(MKMapPoint other) {
        return this.getX() == other.getX() && this.getY() == other.getY();
    }

    public boolean equals(Object obj) {
        return obj instanceof MKMapPoint && this.equalsTo((MKMapPoint)((Object)obj));
    }

    public String toString() {
        return String.format("{%.1f, %.1f}", this.getX(), this.getY());
    }

    @Bridge(symbol="MKMapPointForCoordinate", optional=true)
    @ByVal
    public static native MKMapPoint create(@ByVal CLLocationCoordinate2D var0);

    public CLLocationCoordinate2D toCoordinate() {
        return MKMapPoint.toCoordinate(this);
    }

    @Bridge(symbol="MKCoordinateForMapPoint", optional=true)
    @ByVal
    private static native CLLocationCoordinate2D toCoordinate(@ByVal MKMapPoint var0);

    @Bridge(symbol="MKMetersPerMapPointAtLatitude", optional=true)
    public static native double getMetersPerMapPoint(double var0);

    @Bridge(symbol="MKMapPointsPerMeterAtLatitude", optional=true)
    public static native double getMapPointsPerMeter(double var0);

    @Bridge(symbol="MKMetersBetweenMapPoints", optional=true)
    public static native double getMetersBetween(@ByVal MKMapPoint var0, @ByVal MKMapPoint var1);

    static {
        Bro.bind(MKMapPoint.class);
    }

    public static class MKMapPointPtr
    extends Ptr<MKMapPoint, MKMapPointPtr> {
    }
}

