/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mapkit;

import org.robovm.apple.corelocation.CLLocationCoordinate2D;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.mapkit.MKCoordinateSpan;
import org.robovm.apple.mapkit.MKDirectionsMode;
import org.robovm.apple.mapkit.MKMapCamera;
import org.robovm.apple.mapkit.MKMapType;
import org.robovm.apple.mapkit.NSValueExtensions;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="MapKit")
public class MKLaunchOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    public MKLaunchOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    protected MKLaunchOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public MKDirectionsMode getDirectionsMode() {
        if (this.data.containsKey(MKLaunchOptions.DirectionsModeKey())) {
            NSString val = (NSString)this.data.get(MKLaunchOptions.DirectionsModeKey());
            return MKDirectionsMode.valueOf(val);
        }
        return null;
    }

    public MKLaunchOptions setDirectionsMode(MKDirectionsMode mode) {
        this.data.put(MKLaunchOptions.DirectionsModeKey(), mode.value());
        return this;
    }

    public MKMapType getMapType() {
        if (this.data.containsKey(MKLaunchOptions.MapTypeKey())) {
            NSNumber val = (NSNumber)this.data.get(MKLaunchOptions.MapTypeKey());
            return MKMapType.valueOf(val.intValue());
        }
        return null;
    }

    public MKLaunchOptions setMapType(MKMapType type) {
        this.data.put(MKLaunchOptions.MapTypeKey(), NSNumber.valueOf((int)type.value()));
        return this;
    }

    public boolean isShowingTraffic() {
        if (this.data.containsKey(MKLaunchOptions.ShowsTrafficKey())) {
            NSNumber val = (NSNumber)this.data.get(MKLaunchOptions.ShowsTrafficKey());
            return val.booleanValue();
        }
        return false;
    }

    public MKLaunchOptions setShowsTraffic(boolean showsTraffic) {
        this.data.put(MKLaunchOptions.ShowsTrafficKey(), NSNumber.valueOf(showsTraffic));
        return this;
    }

    @ByVal
    public CLLocationCoordinate2D getMapCenter() {
        if (this.data.containsKey(MKLaunchOptions.MapCenterKey())) {
            NSValue val = (NSValue)this.data.get(MKLaunchOptions.MapCenterKey());
            return NSValueExtensions.getMKCoordinateValue(val);
        }
        return null;
    }

    public MKLaunchOptions setMapCenter(@ByVal CLLocationCoordinate2D center) {
        this.data.put(MKLaunchOptions.MapCenterKey(), NSValueExtensions.create(center));
        return this;
    }

    @ByVal
    public MKCoordinateSpan getMapSpan() {
        if (this.data.containsKey(MKLaunchOptions.MapSpanKey())) {
            NSValue val = (NSValue)this.data.get(MKLaunchOptions.MapSpanKey());
            return NSValueExtensions.getMKCoordinateSpanValue(val);
        }
        return null;
    }

    public MKLaunchOptions setMapSpan(@ByVal MKCoordinateSpan span) {
        this.data.put(MKLaunchOptions.MapSpanKey(), NSValueExtensions.create(span));
        return this;
    }

    public MKMapCamera getCamera() {
        if (this.data.containsKey(MKLaunchOptions.CameraKey())) {
            MKMapCamera val = (MKMapCamera)this.data.get(MKLaunchOptions.CameraKey());
            return val;
        }
        return null;
    }

    public MKLaunchOptions setCamera(MKMapCamera camera) {
        this.data.put(MKLaunchOptions.CameraKey(), camera);
        return this;
    }

    @GlobalValue(symbol="MKLaunchOptionsDirectionsModeKey", optional=true)
    protected static native NSString DirectionsModeKey();

    @GlobalValue(symbol="MKLaunchOptionsMapTypeKey", optional=true)
    protected static native NSString MapTypeKey();

    @GlobalValue(symbol="MKLaunchOptionsShowsTrafficKey", optional=true)
    protected static native NSString ShowsTrafficKey();

    @GlobalValue(symbol="MKLaunchOptionsMapCenterKey", optional=true)
    protected static native NSString MapCenterKey();

    @GlobalValue(symbol="MKLaunchOptionsMapSpanKey", optional=true)
    protected static native NSString MapSpanKey();

    @GlobalValue(symbol="MKLaunchOptionsCameraKey", optional=true)
    protected static native NSString CameraKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(MKLaunchOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static MKLaunchOptions toObject(Class<MKLaunchOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new MKLaunchOptions(o);
        }

        @MarshalsPointer
        public static long toNative(MKLaunchOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

