/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="ImageIO")
public class CGImageSourceOptions
extends CocoaUtility {
    private CFDictionary data;

    protected CGImageSourceOptions(CFDictionary data) {
        this.data = data;
    }

    public CGImageSourceOptions() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public String getTypeIdentifierHint() {
        if (this.data.containsKey(CGImageSourceOptions.TypeIdentifierHintKey())) {
            CFString val = this.data.get(CGImageSourceOptions.TypeIdentifierHintKey(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGImageSourceOptions setTypeIdentifierHint(String typeIdentifier) {
        this.data.put(CGImageSourceOptions.TypeIdentifierHintKey(), new CFString(typeIdentifier));
        return this;
    }

    public boolean shouldCache() {
        if (this.data.containsKey(CGImageSourceOptions.ShouldCacheKey())) {
            CFBoolean val = this.data.get(CGImageSourceOptions.ShouldCacheKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCache(boolean cache) {
        this.data.put(CGImageSourceOptions.ShouldCacheKey(), CFBoolean.valueOf(cache));
        return this;
    }

    public boolean shouldCacheImmediately() {
        if (this.data.containsKey(CGImageSourceOptions.ShouldCacheImmediatelyKey())) {
            CFBoolean val = this.data.get(CGImageSourceOptions.ShouldCacheImmediatelyKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCacheImmediately(boolean cache) {
        this.data.put(CGImageSourceOptions.ShouldCacheImmediatelyKey(), CFBoolean.valueOf(cache));
        return this;
    }

    public boolean shouldAllowFloat() {
        if (this.data.containsKey(CGImageSourceOptions.ShouldAllowFloatKey())) {
            CFBoolean val = this.data.get(CGImageSourceOptions.ShouldAllowFloatKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldAllowFloat(boolean allowFloat) {
        this.data.put(CGImageSourceOptions.ShouldAllowFloatKey(), CFBoolean.valueOf(allowFloat));
        return this;
    }

    public boolean shouldCreateThumbnailFromImageIfAbsent() {
        if (this.data.containsKey(CGImageSourceOptions.CreateThumbnailFromImageIfAbsentKey())) {
            CFBoolean val = this.data.get(CGImageSourceOptions.CreateThumbnailFromImageIfAbsentKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCreateThumbnailFromImageIfAbsent(boolean createThumbnail) {
        this.data.put(CGImageSourceOptions.CreateThumbnailFromImageIfAbsentKey(), CFBoolean.valueOf(createThumbnail));
        return this;
    }

    public boolean shouldCreateThumbnailFromImageAlways() {
        if (this.data.containsKey(CGImageSourceOptions.CreateThumbnailFromImageAlwaysKey())) {
            CFBoolean val = this.data.get(CGImageSourceOptions.CreateThumbnailFromImageAlwaysKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCreateThumbnailFromImageAlways(boolean createThumbnail) {
        this.data.put(CGImageSourceOptions.CreateThumbnailFromImageAlwaysKey(), CFBoolean.valueOf(createThumbnail));
        return this;
    }

    public long getThumbnailMaxPixelSize() {
        if (this.data.containsKey(CGImageSourceOptions.ThumbnailMaxPixelSizeKey())) {
            CFNumber val = this.data.get(CGImageSourceOptions.ThumbnailMaxPixelSizeKey(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageSourceOptions setThumbnailMaxPixelSize(long maxSize) {
        this.data.put(CGImageSourceOptions.ThumbnailMaxPixelSizeKey(), CFNumber.valueOf(maxSize));
        return this;
    }

    public boolean shouldCreateThumbnailWithTransform() {
        if (this.data.containsKey(CGImageSourceOptions.CreateThumbnailWithTransformKey())) {
            CFBoolean val = this.data.get(CGImageSourceOptions.CreateThumbnailWithTransformKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCreateThumbnailWithTransform(boolean transform) {
        this.data.put(CGImageSourceOptions.CreateThumbnailWithTransformKey(), CFBoolean.valueOf(transform));
        return this;
    }

    @GlobalValue(symbol="kCGImageSourceTypeIdentifierHint", optional=true)
    protected static native CFString TypeIdentifierHintKey();

    @GlobalValue(symbol="kCGImageSourceShouldCache", optional=true)
    protected static native CFString ShouldCacheKey();

    @GlobalValue(symbol="kCGImageSourceShouldCacheImmediately", optional=true)
    protected static native CFString ShouldCacheImmediatelyKey();

    @GlobalValue(symbol="kCGImageSourceShouldAllowFloat", optional=true)
    protected static native CFString ShouldAllowFloatKey();

    @GlobalValue(symbol="kCGImageSourceCreateThumbnailFromImageIfAbsent", optional=true)
    protected static native CFString CreateThumbnailFromImageIfAbsentKey();

    @GlobalValue(symbol="kCGImageSourceCreateThumbnailFromImageAlways", optional=true)
    protected static native CFString CreateThumbnailFromImageAlwaysKey();

    @GlobalValue(symbol="kCGImageSourceThumbnailMaxPixelSize", optional=true)
    protected static native CFString ThumbnailMaxPixelSizeKey();

    @GlobalValue(symbol="kCGImageSourceCreateThumbnailWithTransform", optional=true)
    protected static native CFString CreateThumbnailWithTransformKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CGImageSourceOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImageSourceOptions toObject(Class<CGImageSourceOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImageSourceOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CGImageSourceOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

