/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.imageio.CGImagePropertyGIF;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="ImageIO")
public class CGImagePropertyGIFData {
    private CFDictionary data;

    protected CGImagePropertyGIFData(CFDictionary data) {
        this.data = data;
    }

    public CGImagePropertyGIFData() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public boolean has(CGImagePropertyGIF property) {
        return this.data.containsKey(property.value());
    }

    public String getString(CGImagePropertyGIF property) {
        if (this.has(property)) {
            CFString val = this.data.get(property.value(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public double getNumber(CGImagePropertyGIF property) {
        if (this.has(property)) {
            CFNumber val = this.data.get(property.value(), CFNumber.class);
            return val.doubleValue();
        }
        return 0.0;
    }

    public CGImagePropertyGIFData set(CGImagePropertyGIF property, String value) {
        this.data.put(property.value(), new CFString(value));
        return this;
    }

    public CGImagePropertyGIFData set(CGImagePropertyGIF property, double value) {
        this.data.put(property.value(), CFNumber.valueOf(value));
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CGImagePropertyGIFData.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImagePropertyGIFData toObject(Class<CGImagePropertyGIFData> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImagePropertyGIFData(o);
        }

        @MarshalsPointer
        public static long toNative(CGImagePropertyGIFData o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

