/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.imageio.CGImageProperty8BIMData;
import org.robovm.apple.imageio.CGImagePropertyCIFFData;
import org.robovm.apple.imageio.CGImagePropertyCanonData;
import org.robovm.apple.imageio.CGImagePropertyColorModel;
import org.robovm.apple.imageio.CGImagePropertyDNGData;
import org.robovm.apple.imageio.CGImagePropertyExifAuxData;
import org.robovm.apple.imageio.CGImagePropertyExifData;
import org.robovm.apple.imageio.CGImagePropertyGIFData;
import org.robovm.apple.imageio.CGImagePropertyGPSData;
import org.robovm.apple.imageio.CGImagePropertyIPTCData;
import org.robovm.apple.imageio.CGImagePropertyJFIFData;
import org.robovm.apple.imageio.CGImagePropertyNikonData;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.apple.imageio.CGImagePropertyPNGData;
import org.robovm.apple.imageio.CGImagePropertyTIFFData;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="ImageIO")
public class CGImageProperties
extends CocoaUtility {
    protected CFDictionary data;

    public CGImageProperties(CFDictionary data) {
        this.data = data;
    }

    public CGImageProperties() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public CGImagePropertyTIFFData getTIFFData() {
        if (this.data.containsKey(CGImageProperties.TIFFDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.TIFFDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyTIFFData(val);
        }
        return null;
    }

    public CGImageProperties setTIFFData(CGImagePropertyTIFFData metadata) {
        this.data.put(CGImageProperties.TIFFDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyGIFData getGIFData() {
        if (this.data.containsKey(CGImageProperties.GIFDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.GIFDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyGIFData(val);
        }
        return null;
    }

    public CGImageProperties setGIFData(CGImagePropertyGIFData metadata) {
        this.data.put(CGImageProperties.GIFDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyJFIFData getJFIFData() {
        if (this.data.containsKey(CGImageProperties.JFIFDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.JFIFDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyJFIFData(val);
        }
        return null;
    }

    public CGImageProperties setJFIFData(CGImagePropertyJFIFData metadata) {
        this.data.put(CGImageProperties.JFIFDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyExifData getExifData() {
        if (this.data.containsKey(CGImageProperties.ExifDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.ExifDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyExifData(val);
        }
        return null;
    }

    public CGImageProperties setExifData(CGImagePropertyExifData metadata) {
        this.data.put(CGImageProperties.ExifDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyPNGData getPNGData() {
        if (this.data.containsKey(CGImageProperties.PNGDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.PNGDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyPNGData(val);
        }
        return null;
    }

    public CGImageProperties setPNGData(CGImagePropertyPNGData metadata) {
        this.data.put(CGImageProperties.PNGDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyIPTCData getIPTCData() {
        if (this.data.containsKey(CGImageProperties.IPTCDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.IPTCDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyIPTCData(val);
        }
        return null;
    }

    public CGImageProperties setIPTCData(CGImagePropertyIPTCData metadata) {
        this.data.put(CGImageProperties.PNGDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyGPSData getGPSData() {
        if (this.data.containsKey(CGImageProperties.GPSDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.GPSDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyGPSData(val);
        }
        return null;
    }

    public CGImageProperties setGPSData(CGImagePropertyGPSData metadata) {
        this.data.put(CGImageProperties.GPSDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CFDictionary getRawData() {
        if (this.data.containsKey(CGImageProperties.RawDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.RawDictionaryKey(), CFDictionary.class);
            return val;
        }
        return null;
    }

    public CGImageProperties setRawData(CFDictionary metadata) {
        this.data.put(CGImageProperties.RawDictionaryKey(), metadata);
        return this;
    }

    public CGImagePropertyCIFFData getCIFFData() {
        if (this.data.containsKey(CGImageProperties.CIFFDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.CIFFDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyCIFFData(val);
        }
        return null;
    }

    public CGImageProperties setCIFFData(CGImagePropertyCIFFData metadata) {
        this.data.put(CGImageProperties.CIFFDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImageProperty8BIMData get8BIMData() {
        if (this.data.containsKey(CGImageProperties._8BIMDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties._8BIMDictionaryKey(), CFDictionary.class);
            return new CGImageProperty8BIMData(val);
        }
        return null;
    }

    public CGImageProperties set8BIMData(CGImageProperty8BIMData metadata) {
        this.data.put(CGImageProperties._8BIMDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyDNGData getDNGData() {
        if (this.data.containsKey(CGImageProperties.DNGDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.DNGDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyDNGData(val);
        }
        return null;
    }

    public CGImageProperties setDNGData(CGImagePropertyDNGData metadata) {
        this.data.put(CGImageProperties.DNGDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyExifAuxData getExifAuxData() {
        if (this.data.containsKey(CGImageProperties.ExifAuxDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.ExifAuxDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyExifAuxData(val);
        }
        return null;
    }

    public CGImageProperties setExifAuxData(CGImagePropertyExifAuxData metadata) {
        this.data.put(CGImageProperties.ExifAuxDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyCanonData getMakerCanonData() {
        if (this.data.containsKey(CGImageProperties.MakerCanonDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.MakerCanonDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyCanonData(val);
        }
        return null;
    }

    public CGImageProperties setMakerCanonData(CGImagePropertyCanonData metadata) {
        this.data.put(CGImageProperties.MakerCanonDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CGImagePropertyNikonData getMakerNikonData() {
        if (this.data.containsKey(CGImageProperties.MakerNikonDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.MakerNikonDictionaryKey(), CFDictionary.class);
            return new CGImagePropertyNikonData(val);
        }
        return null;
    }

    public CGImageProperties setMakerNikonData(CGImagePropertyNikonData metadata) {
        this.data.put(CGImageProperties.MakerNikonDictionaryKey(), metadata.getDictionary());
        return this;
    }

    public CFDictionary getMakerMinoltaData() {
        if (this.data.containsKey(CGImageProperties.MakerMinoltaDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.MakerMinoltaDictionaryKey(), CFDictionary.class);
            return val;
        }
        return null;
    }

    public CGImageProperties setMakerMinoltaData(CFDictionary metadata) {
        this.data.put(CGImageProperties.MakerMinoltaDictionaryKey(), metadata);
        return this;
    }

    public CFDictionary getMakerFujiData() {
        if (this.data.containsKey(CGImageProperties.MakerFujiDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.MakerFujiDictionaryKey(), CFDictionary.class);
            return val;
        }
        return null;
    }

    public CGImageProperties setMakerFujiData(CFDictionary metadata) {
        this.data.put(CGImageProperties.MakerFujiDictionaryKey(), metadata);
        return this;
    }

    public CFDictionary getMakerOlympusData() {
        if (this.data.containsKey(CGImageProperties.MakerOlympusDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.MakerOlympusDictionaryKey(), CFDictionary.class);
            return val;
        }
        return null;
    }

    public CGImageProperties setMakerOlympusData(CFDictionary metadata) {
        this.data.put(CGImageProperties.MakerOlympusDictionaryKey(), metadata);
        return this;
    }

    public CFDictionary getMakerPentaxData() {
        if (this.data.containsKey(CGImageProperties.MakerPentaxDictionaryKey())) {
            CFDictionary val = this.data.get(CGImageProperties.MakerPentaxDictionaryKey(), CFDictionary.class);
            return val;
        }
        return null;
    }

    public CGImageProperties setMakerPentaxData(CFDictionary metadata) {
        this.data.put(CGImageProperties.MakerPentaxDictionaryKey(), metadata);
        return this;
    }

    public long getFileSize() {
        if (this.data.containsKey(CGImageProperties.FileSizeKey())) {
            CFNumber val = this.data.get(CGImageProperties.FileSizeKey(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageProperties setFileSize(long fileSize) {
        this.data.put(CGImageProperties.FileSizeKey(), CFNumber.valueOf(fileSize));
        return this;
    }

    public long getDPIHeight() {
        if (this.data.containsKey(CGImageProperties.DPIHeightKey())) {
            CFNumber val = this.data.get(CGImageProperties.DPIHeightKey(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageProperties setDPIHeight(long dpi) {
        this.data.put(CGImageProperties.DPIHeightKey(), CFNumber.valueOf(dpi));
        return this;
    }

    public long getDPIWidth() {
        if (this.data.containsKey(CGImageProperties.DPIWidthKey())) {
            CFNumber val = this.data.get(CGImageProperties.DPIWidthKey(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageProperties setDPIWidth(long dpi) {
        this.data.put(CGImageProperties.DPIWidthKey(), CFNumber.valueOf(dpi));
        return this;
    }

    public long getPixelWidth() {
        if (this.data.containsKey(CGImageProperties.PixelWidthKey())) {
            CFNumber val = this.data.get(CGImageProperties.PixelWidthKey(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageProperties setPixelWidth(long width) {
        this.data.put(CGImageProperties.PixelWidthKey(), CFNumber.valueOf(width));
        return this;
    }

    public long getPixelHeight() {
        if (this.data.containsKey(CGImageProperties.PixelHeightKey())) {
            CFNumber val = this.data.get(CGImageProperties.PixelHeightKey(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageProperties setPixelHeight(long height) {
        this.data.put(CGImageProperties.PixelHeightKey(), CFNumber.valueOf(height));
        return this;
    }

    public int getDepth() {
        if (this.data.containsKey(CGImageProperties.DepthKey())) {
            CFNumber val = this.data.get(CGImageProperties.DepthKey(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CGImageProperties setDepth(int depth) {
        this.data.put(CGImageProperties.DepthKey(), CFNumber.valueOf(depth));
        return this;
    }

    public CGImagePropertyOrientation getOrientation() {
        if (this.data.containsKey(CGImageProperties.OrientationKey())) {
            CFNumber val = this.data.get(CGImageProperties.OrientationKey(), CFNumber.class);
            return CGImagePropertyOrientation.valueOf(val.longValue());
        }
        return null;
    }

    public CGImageProperties setOrientation(CGImagePropertyOrientation orientation) {
        this.data.put(CGImageProperties.OrientationKey(), CFNumber.valueOf(orientation.value()));
        return this;
    }

    public boolean isContainingFloatingPointPixels() {
        if (this.data.containsKey(CGImageProperties.IsFloatKey())) {
            CFBoolean val = this.data.get(CGImageProperties.IsFloatKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageProperties setContainsFloatingPointPixels(boolean isFloat) {
        this.data.put(CGImageProperties.IsFloatKey(), CFBoolean.valueOf(isFloat));
        return this;
    }

    public boolean isIndexed() {
        if (this.data.containsKey(CGImageProperties.IsIndexedKey())) {
            CFBoolean val = this.data.get(CGImageProperties.IsIndexedKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageProperties setIndexed(boolean isIndexed) {
        this.data.put(CGImageProperties.IsIndexedKey(), CFBoolean.valueOf(isIndexed));
        return this;
    }

    public boolean hasAlphaChannel() {
        if (this.data.containsKey(CGImageProperties.HasAlphaKey())) {
            CFBoolean val = this.data.get(CGImageProperties.HasAlphaKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageProperties setHasAlphaChannel(boolean alphaChannel) {
        this.data.put(CGImageProperties.HasAlphaKey(), CFBoolean.valueOf(alphaChannel));
        return this;
    }

    public CGImagePropertyColorModel getColorModel() {
        if (this.data.containsKey(CGImageProperties.ColorModelKey())) {
            CFString val = this.data.get(CGImageProperties.ColorModelKey(), CFString.class);
            return CGImagePropertyColorModel.valueOf(val);
        }
        return null;
    }

    public CGImageProperties setColorModel(CGImagePropertyColorModel colorModel) {
        this.data.put(CGImageProperties.ColorModelKey(), colorModel.value());
        return this;
    }

    public String getICCProfile() {
        if (this.data.containsKey(CGImageProperties.ProfileNameKey())) {
            CFString val = this.data.get(CGImageProperties.ProfileNameKey(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGImageProperties setICCProfile(String profile) {
        this.data.put(CGImageProperties.ProfileNameKey(), new CFString(profile));
        return this;
    }

    @GlobalValue(symbol="kCGImagePropertyTIFFDictionary", optional=true)
    protected static native CFString TIFFDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyGIFDictionary", optional=true)
    protected static native CFString GIFDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyJFIFDictionary", optional=true)
    protected static native CFString JFIFDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyExifDictionary", optional=true)
    protected static native CFString ExifDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyPNGDictionary", optional=true)
    protected static native CFString PNGDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyIPTCDictionary", optional=true)
    protected static native CFString IPTCDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyGPSDictionary", optional=true)
    protected static native CFString GPSDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyRawDictionary", optional=true)
    protected static native CFString RawDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyCIFFDictionary", optional=true)
    protected static native CFString CIFFDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyMakerCanonDictionary", optional=true)
    protected static native CFString MakerCanonDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyMakerNikonDictionary", optional=true)
    protected static native CFString MakerNikonDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyMakerMinoltaDictionary", optional=true)
    protected static native CFString MakerMinoltaDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyMakerFujiDictionary", optional=true)
    protected static native CFString MakerFujiDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyMakerOlympusDictionary", optional=true)
    protected static native CFString MakerOlympusDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyMakerPentaxDictionary", optional=true)
    protected static native CFString MakerPentaxDictionaryKey();

    @GlobalValue(symbol="kCGImageProperty8BIMDictionary", optional=true)
    protected static native CFString _8BIMDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyDNGDictionary", optional=true)
    protected static native CFString DNGDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyExifAuxDictionary", optional=true)
    protected static native CFString ExifAuxDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyMakerAppleDictionary", optional=true)
    protected static native CFString MakerAppleDictionaryKey();

    @GlobalValue(symbol="kCGImagePropertyFileSize", optional=true)
    protected static native CFString FileSizeKey();

    @GlobalValue(symbol="kCGImagePropertyPixelHeight", optional=true)
    protected static native CFString PixelHeightKey();

    @GlobalValue(symbol="kCGImagePropertyPixelWidth", optional=true)
    protected static native CFString PixelWidthKey();

    @GlobalValue(symbol="kCGImagePropertyDPIHeight", optional=true)
    protected static native CFString DPIHeightKey();

    @GlobalValue(symbol="kCGImagePropertyDPIWidth", optional=true)
    protected static native CFString DPIWidthKey();

    @GlobalValue(symbol="kCGImagePropertyDepth", optional=true)
    protected static native CFString DepthKey();

    @GlobalValue(symbol="kCGImagePropertyOrientation", optional=true)
    protected static native CFString OrientationKey();

    @GlobalValue(symbol="kCGImagePropertyIsFloat", optional=true)
    protected static native CFString IsFloatKey();

    @GlobalValue(symbol="kCGImagePropertyIsIndexed", optional=true)
    protected static native CFString IsIndexedKey();

    @GlobalValue(symbol="kCGImagePropertyHasAlpha", optional=true)
    protected static native CFString HasAlphaKey();

    @GlobalValue(symbol="kCGImagePropertyColorModel", optional=true)
    protected static native CFString ColorModelKey();

    @GlobalValue(symbol="kCGImagePropertyProfileName", optional=true)
    protected static native CFString ProfileNameKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CGImageProperties.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImageProperties toObject(Class<CGImageProperties> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImageProperties(o);
        }

        @MarshalsPointer
        public static long toNative(CGImageProperties o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

