/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColor;
import org.robovm.apple.imageio.CGImageProperties;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="ImageIO")
public class CGImageDestinationProperties
extends CGImageProperties {
    public CGImageDestinationProperties(CFDictionary data) {
        this.data = data;
    }

    public CGImageDestinationProperties() {
        this.data = CFMutableDictionary.create();
    }

    public double getLossyCompressionQuality() {
        if (this.data.containsKey(CGImageDestinationProperties.LossyCompressionQualityKey())) {
            CFNumber val = this.data.get(CGImageDestinationProperties.LossyCompressionQualityKey(), CFNumber.class);
            return val.doubleValue();
        }
        return 1.0;
    }

    public CGImageDestinationProperties setLossyCompressionQuality(double quality) {
        this.data.put(CGImageDestinationProperties.LossyCompressionQualityKey(), CFNumber.valueOf(quality));
        return this;
    }

    public CGColor getBackgroundColor() {
        if (this.data.containsKey(CGImageDestinationProperties.BackgroundColorKey())) {
            CGColor val = this.data.get(CGImageDestinationProperties.BackgroundColorKey(), CGColor.class);
            return val;
        }
        return null;
    }

    public CGImageDestinationProperties setBackgroundColor(CGColor color) {
        this.data.put(CGImageDestinationProperties.BackgroundColorKey(), color);
        return this;
    }

    public long getMaxPixelSize() {
        if (this.data.containsKey(CGImageDestinationProperties.ImageMaxPixelSizeKey())) {
            CFNumber val = this.data.get(CGImageDestinationProperties.ImageMaxPixelSizeKey(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageDestinationProperties setMaxPixelSize(long size) {
        this.data.put(CGImageDestinationProperties.ImageMaxPixelSizeKey(), CFNumber.valueOf(size));
        return this;
    }

    public boolean isEmbeddingThumbnail() {
        if (this.data.containsKey(CGImageDestinationProperties.EmbedThumbnailKey())) {
            CFBoolean val = this.data.get(CGImageDestinationProperties.EmbedThumbnailKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationProperties setEmbedThumbnail(boolean embed) {
        this.data.put(CGImageDestinationProperties.EmbedThumbnailKey(), CFBoolean.valueOf(embed));
        return this;
    }

    @GlobalValue(symbol="kCGImageDestinationLossyCompressionQuality", optional=true)
    protected static native CFString LossyCompressionQualityKey();

    @GlobalValue(symbol="kCGImageDestinationBackgroundColor", optional=true)
    protected static native CFString BackgroundColorKey();

    @GlobalValue(symbol="kCGImageDestinationImageMaxPixelSize", optional=true)
    protected static native CFString ImageMaxPixelSizeKey();

    @GlobalValue(symbol="kCGImageDestinationEmbedThumbnail", optional=true)
    protected static native CFString EmbedThumbnailKey();

    static {
        Bro.bind(CGImageDestinationProperties.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImageDestinationProperties toObject(Class<CGImageDestinationProperties> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImageDestinationProperties(o);
        }

        @MarshalsPointer
        public static long toNative(CGImageDestinationProperties o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

