/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.imageio.CGImageMetadata;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="ImageIO")
public class CGImageDestinationCopySourceOptions
extends CocoaUtility {
    private CFDictionary data;

    protected CGImageDestinationCopySourceOptions(CFDictionary data) {
        this.data = data;
    }

    public CGImageDestinationCopySourceOptions() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public CGImageMetadata getMetadata() {
        if (this.data.containsKey(CGImageDestinationCopySourceOptions.DestinationMetadataKey())) {
            CGImageMetadata val = this.data.get(CGImageDestinationCopySourceOptions.DestinationMetadataKey(), CGImageMetadata.class);
            return val;
        }
        return null;
    }

    public CGImageDestinationCopySourceOptions setMetadata(CGImageMetadata metadata) {
        this.data.put(CGImageDestinationCopySourceOptions.DestinationMetadataKey(), metadata);
        return this;
    }

    public boolean isMergingMetadata() {
        if (this.data.containsKey(CGImageDestinationCopySourceOptions.DestinationMergeMetadataKey())) {
            CFBoolean val = this.data.get(CGImageDestinationCopySourceOptions.DestinationMergeMetadataKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationCopySourceOptions setMergeMetadata(boolean merge) {
        this.data.put(CGImageDestinationCopySourceOptions.DestinationMergeMetadataKey(), CFBoolean.valueOf(merge));
        return this;
    }

    public boolean shouldExcludeXMP() {
        if (this.data.containsKey(CGImageDestinationCopySourceOptions.MetadataShouldExcludeXMPKey())) {
            CFBoolean val = this.data.get(CGImageDestinationCopySourceOptions.MetadataShouldExcludeXMPKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationCopySourceOptions setShouldExcludeXMP(boolean exclude) {
        this.data.put(CGImageDestinationCopySourceOptions.MetadataShouldExcludeXMPKey(), CFBoolean.valueOf(exclude));
        return this;
    }

    public boolean shouldExcludeGPS() {
        if (this.data.containsKey(CGImageDestinationCopySourceOptions.MetadataShouldExcludeGPSKey())) {
            CFBoolean val = this.data.get(CGImageDestinationCopySourceOptions.MetadataShouldExcludeGPSKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationCopySourceOptions setShouldExcludeGPS(boolean exclude) {
        this.data.put(CGImageDestinationCopySourceOptions.MetadataShouldExcludeGPSKey(), CFBoolean.valueOf(exclude));
        return this;
    }

    public String getDateTime() {
        if (this.data.containsKey(CGImageDestinationCopySourceOptions.DestinationDateTimeKey())) {
            CFString val = this.data.get(CGImageDestinationCopySourceOptions.DestinationDateTimeKey(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGImageDestinationCopySourceOptions setDateTime(String dateTime) {
        this.data.put(CGImageDestinationCopySourceOptions.DestinationDateTimeKey(), new CFString(dateTime));
        return this;
    }

    public CGImageDestinationCopySourceOptions setDateTime(NSDate dateTime) {
        this.data.put(CGImageDestinationCopySourceOptions.DestinationDateTimeKey(), (NativeObject)dateTime);
        return this;
    }

    public CGImagePropertyOrientation getOrientation() {
        if (this.data.containsKey(CGImageDestinationCopySourceOptions.DestinationOrientationKey())) {
            CFNumber val = this.data.get(CGImageDestinationCopySourceOptions.DestinationOrientationKey(), CFNumber.class);
            return CGImagePropertyOrientation.valueOf(val.intValue());
        }
        return null;
    }

    public CGImageDestinationCopySourceOptions setOrientation(CGImagePropertyOrientation orientation) {
        this.data.put(CGImageDestinationCopySourceOptions.DestinationOrientationKey(), CFNumber.valueOf(orientation.value()));
        return this;
    }

    @GlobalValue(symbol="kCGImageDestinationMetadata", optional=true)
    protected static native CFString DestinationMetadataKey();

    @GlobalValue(symbol="kCGImageDestinationMergeMetadata", optional=true)
    protected static native CFString DestinationMergeMetadataKey();

    @GlobalValue(symbol="kCGImageMetadataShouldExcludeXMP", optional=true)
    protected static native CFString MetadataShouldExcludeXMPKey();

    @GlobalValue(symbol="kCGImageMetadataShouldExcludeGPS", optional=true)
    protected static native CFString MetadataShouldExcludeGPSKey();

    @GlobalValue(symbol="kCGImageDestinationDateTime", optional=true)
    protected static native CFString DestinationDateTimeKey();

    @GlobalValue(symbol="kCGImageDestinationOrientation", optional=true)
    protected static native CFString DestinationOrientationKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CGImageDestinationCopySourceOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImageDestinationCopySourceOptions toObject(Class<CGImageDestinationCopySourceOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImageDestinationCopySourceOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CGImageDestinationCopySourceOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

