/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.healthkit;

import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSTimeZone;
import org.robovm.apple.healthkit.HKBodyTemperatureSensorLocation;
import org.robovm.apple.healthkit.HKHeartRateSensorLocation;
import org.robovm.apple.healthkit.HKMetadataKey;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class HKMetadata {
    private NSDictionary<NSString, NSObject> data;

    protected HKMetadata(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public HKMetadata() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSObject get(String property) {
        return this.data.get(new NSString(property));
    }

    public NSObject get(HKMetadataKey property) {
        return this.data.get(property.value());
    }

    public boolean contains(String property) {
        return this.data.containsKey(new NSString(property));
    }

    public boolean contains(HKMetadataKey property) {
        return this.data.containsKey(property.value());
    }

    public HKMetadata put(String property, NSObject value) {
        this.data.put(new NSString(property), value);
        return this;
    }

    public HKMetadata put(HKMetadataKey property, NSObject value) {
        this.data.put(property.value(), value);
        return this;
    }

    public String getDeviceSerialNumber() {
        if (this.contains(HKMetadataKey.DeviceSerialNumber)) {
            NSString val = (NSString)this.get(HKMetadataKey.DeviceSerialNumber);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setDeviceSerialNumber(String serial) {
        this.put(HKMetadataKey.DeviceSerialNumber, (NSObject)new NSString(serial));
        return this;
    }

    public HKBodyTemperatureSensorLocation getBodyTemperatureSensorLocation() {
        if (this.contains(HKMetadataKey.BodyTemperatureSensorLocation)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.BodyTemperatureSensorLocation);
            return HKBodyTemperatureSensorLocation.valueOf(val.longValue());
        }
        return null;
    }

    public HKMetadata setBodyTemperatureSensorLocation(HKBodyTemperatureSensorLocation location) {
        this.put(HKMetadataKey.BodyTemperatureSensorLocation, (NSObject)NSNumber.valueOf(location.value()));
        return this;
    }

    public HKHeartRateSensorLocation getHeartRateSensorLocation() {
        if (this.contains(HKMetadataKey.HeartRateSensorLocation)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.HeartRateSensorLocation);
            return HKHeartRateSensorLocation.valueOf(val.longValue());
        }
        return null;
    }

    public HKMetadata setHeartRateSensorLocation(HKHeartRateSensorLocation location) {
        this.put(HKMetadataKey.HeartRateSensorLocation, (NSObject)NSNumber.valueOf(location.value()));
        return this;
    }

    public String getFoodType() {
        if (this.contains(HKMetadataKey.FoodType)) {
            NSString val = (NSString)this.get(HKMetadataKey.FoodType);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setFoodType(String foodType) {
        this.put(HKMetadataKey.FoodType, (NSObject)new NSString(foodType));
        return this;
    }

    public String getUDIDeviceIdentifier() {
        if (this.contains(HKMetadataKey.UDIDeviceIdentifier)) {
            NSString val = (NSString)this.get(HKMetadataKey.UDIDeviceIdentifier);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setUDIDeviceIdentifier(String deviceIdentifier) {
        this.put(HKMetadataKey.UDIDeviceIdentifier, (NSObject)new NSString(deviceIdentifier));
        return this;
    }

    public String getUDIProductionIdentifier() {
        if (this.contains(HKMetadataKey.UDIProductionIdentifier)) {
            NSString val = (NSString)this.get(HKMetadataKey.UDIProductionIdentifier);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setUDIProductionIdentifier(String identifier) {
        this.put(HKMetadataKey.UDIProductionIdentifier, (NSObject)new NSString(identifier));
        return this;
    }

    public String getDigitalSignature() {
        if (this.contains(HKMetadataKey.DigitalSignature)) {
            NSString val = (NSString)this.get(HKMetadataKey.DigitalSignature);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setDigitalSignature(String signature) {
        this.put(HKMetadataKey.DigitalSignature, (NSObject)new NSString(signature));
        return this;
    }

    public String getExternalUUID() {
        if (this.contains(HKMetadataKey.ExternalUUID)) {
            NSString val = (NSString)this.get(HKMetadataKey.ExternalUUID);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setExternalUUID(String uuid) {
        this.put(HKMetadataKey.ExternalUUID, (NSObject)new NSString(uuid));
        return this;
    }

    public NSTimeZone getTimeZone() {
        if (this.contains(HKMetadataKey.TimeZone)) {
            NSString val = (NSString)this.get(HKMetadataKey.TimeZone);
            return NSTimeZone.fromName(val.toString());
        }
        return null;
    }

    public HKMetadata setTimeZone(NSTimeZone timeZone) {
        this.put(HKMetadataKey.ExternalUUID, (NSObject)new NSString(timeZone.getName()));
        return this;
    }

    public String getDeviceName() {
        if (this.contains(HKMetadataKey.DeviceName)) {
            NSString val = (NSString)this.get(HKMetadataKey.DeviceName);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setDeviceName(String deviceName) {
        this.put(HKMetadataKey.DeviceName, (NSObject)new NSString(deviceName));
        return this;
    }

    public String getDeviceManufacturerName() {
        if (this.contains(HKMetadataKey.DeviceManufacturerName)) {
            NSString val = (NSString)this.get(HKMetadataKey.DeviceManufacturerName);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setDeviceManufacturerName(String name) {
        this.put(HKMetadataKey.DeviceManufacturerName, (NSObject)new NSString(name));
        return this;
    }

    public boolean wasTakenInLab() {
        if (this.contains(HKMetadataKey.WasTakenInLab)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.WasTakenInLab);
            return val.booleanValue();
        }
        return false;
    }

    public HKMetadata setWasTakenInLab(boolean lab) {
        this.put(HKMetadataKey.WasTakenInLab, (NSObject)NSNumber.valueOf(lab));
        return this;
    }

    public double getReferenceRangeLowerLimit() {
        if (this.contains(HKMetadataKey.ReferenceRangeLowerLimit)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.ReferenceRangeLowerLimit);
            return val.doubleValue();
        }
        return 0.0;
    }

    public HKMetadata setReferenceRangeLowerLimit(double limit) {
        this.put(HKMetadataKey.ReferenceRangeLowerLimit, (NSObject)NSNumber.valueOf(limit));
        return this;
    }

    public double getReferenceRangeUpperLimit() {
        if (this.contains(HKMetadataKey.ReferenceRangeUpperLimit)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.ReferenceRangeUpperLimit);
            return val.doubleValue();
        }
        return 0.0;
    }

    public HKMetadata setReferenceRangeUpperLimit(double limit) {
        this.put(HKMetadataKey.ReferenceRangeUpperLimit, (NSObject)NSNumber.valueOf(limit));
        return this;
    }

    public boolean wasUserEntered() {
        if (this.contains(HKMetadataKey.WasUserEntered)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.WasUserEntered);
            return val.booleanValue();
        }
        return false;
    }

    public HKMetadata setWasUserEntered(boolean userEntered) {
        this.put(HKMetadataKey.WasUserEntered, (NSObject)NSNumber.valueOf(userEntered));
        return this;
    }

    public String getWorkoutBrandName() {
        if (this.contains(HKMetadataKey.WorkoutBrandName)) {
            NSString val = (NSString)this.get(HKMetadataKey.WorkoutBrandName);
            return val.toString();
        }
        return null;
    }

    public HKMetadata setWorkoutBrandName(String name) {
        this.put(HKMetadataKey.WorkoutBrandName, (NSObject)new NSString(name));
        return this;
    }

    public boolean isGroupFitness() {
        if (this.contains(HKMetadataKey.GroupFitness)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.GroupFitness);
            return val.booleanValue();
        }
        return false;
    }

    public HKMetadata setGroupFitness(boolean groupFitness) {
        this.put(HKMetadataKey.GroupFitness, (NSObject)NSNumber.valueOf(groupFitness));
        return this;
    }

    public boolean isIndoorWorkout() {
        if (this.contains(HKMetadataKey.IndoorWorkout)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.IndoorWorkout);
            return val.booleanValue();
        }
        return false;
    }

    public HKMetadata setIndoorWorkout(boolean indoorWorkout) {
        this.put(HKMetadataKey.IndoorWorkout, (NSObject)NSNumber.valueOf(indoorWorkout));
        return this;
    }

    public boolean isCoachedWorkout() {
        if (this.contains(HKMetadataKey.CoachedWorkout)) {
            NSNumber val = (NSNumber)this.get(HKMetadataKey.CoachedWorkout);
            return val.booleanValue();
        }
        return false;
    }

    public HKMetadata setCoachedWorkout(boolean coachedWorkout) {
        this.put(HKMetadataKey.CoachedWorkout, (NSObject)NSNumber.valueOf(coachedWorkout));
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(HKMetadata.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static HKMetadata toObject(Class<HKMetadata> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new HKMetadata(o);
        }

        @MarshalsPointer
        public static long toNative(HKMetadata o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

