/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.glkit.GLKErrorUserInfoKey;
import org.robovm.apple.glkit.GLKTextureLoaderErrorCode;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="GLKit")
public class GLKTextureLoaderError
extends NSError {
    protected GLKTextureLoaderError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Override
    public GLKTextureLoaderErrorCode getErrorCode() {
        GLKTextureLoaderErrorCode code = null;
        try {
            code = GLKTextureLoaderErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    public String getError() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(GLKErrorUserInfoKey.Error)) {
            NSString val = (NSString)data.get(GLKErrorUserInfoKey.Error);
            return val.toString();
        }
        return null;
    }

    public long getGLError() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(GLKErrorUserInfoKey.GLError)) {
            NSNumber val = (NSNumber)data.get(GLKErrorUserInfoKey.GLError);
            return val.longValue();
        }
        return 0L;
    }

    @GlobalValue(symbol="GLKTextureLoaderErrorDomain", optional=true)
    public static native String getClassDomain();

    static {
        Bro.bind(GLKTextureLoaderError.class);
    }

    public static class GLKTextureLoaderErrorPtr
    extends Ptr<GLKTextureLoaderError, GLKTextureLoaderErrorPtr> {
    }
}

