/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIImage;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSURLThumbnail
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected NSURLThumbnail(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSURLThumbnail() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public UIImage get1024x1024Size() {
        if (this.data.containsKey(NSURLThumbnail._1024x1024SizeKey())) {
            UIImage val = (UIImage)this.data.get(NSURLThumbnail._1024x1024SizeKey());
            return val;
        }
        return null;
    }

    @GlobalValue(symbol="NSThumbnail1024x1024SizeKey", optional=true)
    protected static native NSString _1024x1024SizeKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSURLThumbnail.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSURLThumbnail toObject(Class<NSURLThumbnail> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSURLThumbnail(o);
        }

        @MarshalsPointer
        public static long toNative(NSURLThumbnail o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

