/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURLAuthenticationMethod;
import org.robovm.apple.foundation.NSURLProtectionSpaceProtocol;
import org.robovm.apple.foundation.NSURLProtectionSpaceProxyType;
import org.robovm.apple.security.SecTrust;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSURLProtectionSpace
extends NSObject {
    public NSURLProtectionSpace() {
    }

    protected NSURLProtectionSpace(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="realm")
    public native String getRealm();

    @Property(selector="receivesCredentialSecurely")
    public native boolean receivesCredentialSecurely();

    @Property(selector="isProxy")
    public native boolean isProxy();

    @Property(selector="host")
    public native String getHost();

    @Property(selector="port")
    @MachineSizedSInt
    public native long getPort();

    @Property(selector="proxyType")
    public native NSURLProtectionSpaceProxyType getProxyType();

    @Property(selector="protocol")
    public native NSURLProtectionSpaceProtocol getProtocol();

    @Property(selector="authenticationMethod")
    public native NSURLAuthenticationMethod getAuthenticationMethod();

    @Property(selector="distinguishedNames")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getDistinguishedNames();

    @Property(selector="serverTrust")
    public native SecTrust getServerTrust();

    public static NSURLProtectionSpace create(String host, long port, NSURLProtectionSpaceProtocol protocol, String realm, NSURLAuthenticationMethod authenticationMethod) {
        NSURLProtectionSpace o = new NSURLProtectionSpace(null);
        long handle = o.init(host, port, protocol, realm, authenticationMethod);
        if (handle == 0L) {
            return null;
        }
        o.initObject(handle);
        return o;
    }

    public static NSURLProtectionSpace createProxy(String host, long port, NSURLProtectionSpaceProxyType type, String realm, NSURLAuthenticationMethod authenticationMethod) {
        NSURLProtectionSpace o = new NSURLProtectionSpace(null);
        long handle = o.init(host, port, type, realm, authenticationMethod);
        if (handle == 0L) {
            return null;
        }
        o.initObject(handle);
        return o;
    }

    @Method(selector="initWithHost:port:protocol:realm:authenticationMethod:")
    @Pointer
    protected native long init(String var1, @MachineSizedSInt long var2, NSURLProtectionSpaceProtocol var4, String var5, NSURLAuthenticationMethod var6);

    @Method(selector="initWithProxyHost:port:type:realm:authenticationMethod:")
    @Pointer
    protected native long init(String var1, @MachineSizedSInt long var2, NSURLProtectionSpaceProxyType var4, String var5, NSURLAuthenticationMethod var6);

    static {
        ObjCRuntime.bind(NSURLProtectionSpace.class);
    }

    public static class NSURLProtectionSpacePtr
    extends Ptr<NSURLProtectionSpace, NSURLProtectionSpacePtr> {
    }
}

