/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURLFileProperty;
import org.robovm.apple.foundation.NSURLFileSystemProperty;
import org.robovm.apple.foundation.NSURLUbiquitousItemProperty;
import org.robovm.apple.foundation.NSURLVolumeProperty;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Foundation")
public abstract class NSURLProperty {
    public abstract NSString value();

    public static NSURLProperty valueOf(NSString value) {
        NSURLProperty property = null;
        property = NSURLFileProperty.valueOf(value);
        if (property != null) {
            return property;
        }
        property = NSURLFileSystemProperty.valueOf(value);
        if (property != null) {
            return property;
        }
        property = NSURLVolumeProperty.valueOf(value);
        if (property != null) {
            return property;
        }
        property = NSURLUbiquitousItemProperty.valueOf(value);
        return property;
    }

    static {
        Bro.bind(NSURLProperty.class);
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSURLProperty> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            return null;
        }

        @MarshalsPointer
        public static long toNative(List<NSURLProperty> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (NSURLProperty i : l) {
                array.add(i.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }
}

