/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSURLError;
import org.robovm.rt.bro.annotation.ForceLinkClass;

@ForceLinkClass(value=NSURLError.class)
public enum NSURLErrorCode implements NSErrorCode
{
    Unknown(-1L),
    Cancelled(-999L),
    BadURL(-1000L),
    TimedOut(-1001L),
    UnsupportedURL(-1002L),
    CannotFindHost(-1003L),
    CannotConnectToHost(-1004L),
    NetworkConnectionLost(-1005L),
    DNSLookupFailed(-1006L),
    HTTPTooManyRedirects(-1007L),
    ResourceUnavailable(-1008L),
    NotConnectedToInternet(-1009L),
    RedirectToNonExistentLocation(-1010L),
    BadServerResponse(-1011L),
    UserCancelledAuthentication(-1012L),
    UserAuthenticationRequired(-1013L),
    ZeroByteResource(-1014L),
    CannotDecodeRawData(-1015L),
    CannotDecodeContentData(-1016L),
    CannotParseResponse(-1017L),
    FileDoesNotExist(-1100L),
    FileIsDirectory(-1101L),
    NoPermissionsToReadFile(-1102L),
    DataLengthExceedsMaximum(-1103L),
    SecureConnectionFailed(-1200L),
    ServerCertificateHasBadDate(-1201L),
    ServerCertificateUntrusted(-1202L),
    ServerCertificateHasUnknownRoot(-1203L),
    ServerCertificateNotYetValid(-1204L),
    ClientCertificateRejected(-1205L),
    ClientCertificateRequired(-1206L),
    CannotLoadFromNetwork(-2000L),
    CannotCreateFile(-3000L),
    CannotOpenFile(-3001L),
    CannotCloseFile(-3002L),
    CannotWriteToFile(-3003L),
    CannotRemoveFile(-3004L),
    CannotMoveFile(-3005L),
    DownloadDecodingFailedMidStream(-3006L),
    DownloadDecodingFailedToComplete(-3007L),
    InternationalRoamingOff(-1018L),
    CallIsActive(-1019L),
    DataNotAllowed(-1020L),
    RequestBodyStreamExhausted(-1021L),
    BackgroundSessionRequiresSharedContainer(-995L),
    BackgroundSessionInUseByAnotherProcess(-996L),
    BackgroundSessionWasDisconnected(-997L);

    private final long n;

    private NSURLErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static NSURLErrorCode valueOf(long n) {
        for (NSURLErrorCode v : NSURLErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + NSURLErrorCode.class.getName());
    }
}

