/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSURLErrorCode;
import org.robovm.apple.foundation.NSURLErrorUserInfoKey;
import org.robovm.apple.foundation.NSURLProperty;
import org.robovm.apple.security.SecTrust;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="Foundation")
public class NSURLError
extends NSError {
    protected NSURLError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Override
    public NSURLErrorCode getErrorCode() {
        NSURLErrorCode code = null;
        try {
            code = NSURLErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    public NSURL getFailingURL() {
        NSErrorUserInfo userInfo = this.getUserInfo();
        if (userInfo.contains(NSURLErrorUserInfoKey.FailingURL)) {
            NSURL val = (NSURL)userInfo.get(NSURLErrorUserInfoKey.FailingURL);
            return val;
        }
        return null;
    }

    public String getFailingURLString() {
        NSErrorUserInfo userInfo = this.getUserInfo();
        if (userInfo.contains(NSURLErrorUserInfoKey.FailingURLString)) {
            NSString val = (NSString)userInfo.get(NSURLErrorUserInfoKey.FailingURLString);
            return val.toString();
        }
        return null;
    }

    public SecTrust getFailingURLPeerTrust() {
        NSErrorUserInfo userInfo = this.getUserInfo();
        if (userInfo.contains(NSURLErrorUserInfoKey.FailingURLPeerTrust)) {
            SecTrust val = userInfo.get(NSURLErrorUserInfoKey.FailingURLPeerTrust, SecTrust.class);
            return val;
        }
        return null;
    }

    public List<NSURLProperty> getUnsetProperties() {
        ArrayList<NSURLProperty> properties = new ArrayList<NSURLProperty>();
        NSErrorUserInfo userInfo = this.getUserInfo();
        if (userInfo.contains(NSURLErrorUserInfoKey.KeysOfUnsetValues)) {
            NSArray val = (NSArray)userInfo.get(NSURLErrorUserInfoKey.KeysOfUnsetValues);
            for (NSString s : val) {
                NSURLProperty p = NSURLProperty.valueOf(s);
                if (p == null) continue;
                properties.add(p);
            }
        }
        return properties;
    }

    @GlobalValue(symbol="NSURLErrorDomain", optional=true)
    public static native String getClassDomain();

    static {
        Bro.bind(NSURLError.class);
    }
}

