/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSURLConnectionDelegate;
import org.robovm.apple.foundation.NSURLRequest;
import org.robovm.apple.foundation.NSURLResponse;
import org.robovm.apple.newsstandkit.NKAssetDownload;
import org.robovm.apple.newsstandkit.NSURLConnectionExtensions;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSURLConnection
extends NSObject {
    public NSURLConnection() {
    }

    protected NSURLConnection(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSURLConnection(NSURLRequest request, NSObject delegate, boolean startImmediately) {
        super(null);
        this.initObject(this.init(request, delegate, startImmediately));
    }

    public NSURLConnection(NSURLRequest request, NSObject delegate) {
        super(null);
        this.initObject(this.init(request, delegate));
    }

    @Property(selector="originalRequest")
    public native NSURLRequest getOriginalRequest();

    @Property(selector="currentRequest")
    public native NSURLRequest getCurrentRequest();

    public void scheduleInRunLoop(NSRunLoop aRunLoop, NSRunLoopMode mode) {
        this.scheduleInRunLoop(aRunLoop, mode.value());
    }

    public void unscheduleFromRunLoop(NSRunLoop aRunLoop, NSRunLoopMode mode) {
        this.unscheduleFromRunLoop(aRunLoop, mode.value());
    }

    @WeaklyLinked
    public NKAssetDownload getNewsstandAssetDownload() {
        return NSURLConnectionExtensions.getNewsstandAssetDownload(this);
    }

    @Method(selector="initWithRequest:delegate:startImmediately:")
    @Pointer
    protected native long init(NSURLRequest var1, NSObject var2, boolean var3);

    @Method(selector="initWithRequest:delegate:")
    @Pointer
    protected native long init(NSURLRequest var1, NSObject var2);

    @Method(selector="start")
    public native void start();

    @Method(selector="cancel")
    public native void cancel();

    @Method(selector="scheduleInRunLoop:forMode:")
    public native void scheduleInRunLoop(NSRunLoop var1, String var2);

    @Method(selector="unscheduleFromRunLoop:forMode:")
    public native void unscheduleFromRunLoop(NSRunLoop var1, String var2);

    @Method(selector="setDelegateQueue:")
    public native void setDelegateQueue(NSOperationQueue var1);

    @Method(selector="connectionWithRequest:delegate:")
    public static native NSURLConnection create(NSURLRequest var0, NSURLConnectionDelegate var1);

    @Method(selector="canHandleRequest:")
    public static native boolean canHandleRequest(NSURLRequest var0);

    public static NSData sendSynchronousRequest(NSURLRequest request, NSURLResponse.NSURLResponsePtr response) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = NSURLConnection.sendSynchronousRequest(request, response, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="sendSynchronousRequest:returningResponse:error:")
    private static native NSData sendSynchronousRequest(NSURLRequest var0, NSURLResponse.NSURLResponsePtr var1, NSError.NSErrorPtr var2);

    @Method(selector="sendAsynchronousRequest:queue:completionHandler:")
    public static native void sendAsynchronousRequest(NSURLRequest var0, NSOperationQueue var1, @Block VoidBlock3<NSURLResponse, NSData, NSError> var2);

    static {
        ObjCRuntime.bind(NSURLConnection.class);
    }

    public static class NSURLConnectionPtr
    extends Ptr<NSURLConnection, NSURLConnectionPtr> {
    }
}

