/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSStringEncoding;
import org.robovm.apple.foundation.NSURLBookmarkCreationOptions;
import org.robovm.apple.foundation.NSURLBookmarkResolutionOptions;
import org.robovm.apple.foundation.NSURLFileProperty;
import org.robovm.apple.foundation.NSURLFileSystemProperty;
import org.robovm.apple.foundation.NSURLProperties;
import org.robovm.apple.foundation.NSURLProperty;
import org.robovm.apple.foundation.NSURLScheme;
import org.robovm.apple.foundation.NSURLUbiquitousItemProperty;
import org.robovm.apple.foundation.NSURLVolumeProperty;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSURL
extends NSObject {
    public NSURL(NSURLScheme scheme, String host, String path) {
        super(null);
        this.initObject(this.init(scheme.value(), host, path));
    }

    public NSURL(NSData bookmarkData, NSURLBookmarkResolutionOptions options, NSURL relativeURL) throws NSErrorException {
        this(bookmarkData, options, relativeURL, new BooleanPtr());
    }

    public NSURL() {
    }

    protected NSURL(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSURL(String scheme, String host, String path) {
        super(null);
        this.initObject(this.init(scheme, host, path));
    }

    public NSURL(String URLString) {
        super(null);
        this.initObject(this.init(URLString));
    }

    public NSURL(String URLString, NSURL baseURL) {
        super(null);
        this.initObject(this.init(URLString, baseURL));
    }

    public NSURL(NSData bookmarkData, NSURLBookmarkResolutionOptions options, NSURL relativeURL, BooleanPtr isStale) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(bookmarkData, options, relativeURL, isStale, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    public NSURL(File file) {
        super(null);
        this.initObject(this.initFileURL(file.getAbsolutePath()));
    }

    public NSURL(File file, boolean isDir) {
        super(null);
        this.initObject(this.initFileURL(file.getAbsolutePath(), isDir));
    }

    public NSURL(URL url) {
        this(url.toString());
    }

    public NSURL(URI uri) {
        this(uri.toString());
    }

    @Property(selector="absoluteString")
    public native String getAbsoluteString();

    @Property(selector="relativeString")
    public native String getRelativeString();

    @Property(selector="baseURL")
    public native NSURL getBaseURL();

    @Property(selector="absoluteURL")
    public native NSURL getAbsoluteURL();

    @Property(selector="scheme")
    public native String getScheme();

    @Property(selector="resourceSpecifier")
    public native String getResourceSpecifier();

    @Property(selector="host")
    public native String getHost();

    @Property(selector="port")
    public native NSNumber getPort();

    @Property(selector="user")
    public native String getUser();

    @Property(selector="password")
    public native String getPassword();

    @Property(selector="path")
    public native String getPath();

    @Property(selector="fragment")
    public native String getFragment();

    @Property(selector="parameterString")
    public native String getParameterString();

    @Property(selector="query")
    public native String getQuery();

    @Property(selector="relativePath")
    public native String getRelativePath();

    @Property(selector="isFileURL")
    public native boolean isFileURL();

    @Property(selector="standardizedURL")
    public native NSURL getStandardizedURL();

    @Property(selector="filePathURL")
    public native NSURL getFilePathURL();

    @Property(selector="pathComponents")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getPathComponents();

    @Property(selector="lastPathComponent")
    public native String getLastPathComponent();

    @Property(selector="pathExtension")
    public native String getPathExtension();

    @Property(selector="URLByDeletingLastPathComponent")
    public native NSURL getURLByDeletingLastPathComponent();

    @Property(selector="URLByDeletingPathExtension")
    public native NSURL getURLByDeletingPathExtension();

    @Property(selector="URLByStandardizingPath")
    public native NSURL getURLByStandardizingPath();

    @Property(selector="URLByResolvingSymlinksInPath")
    public native NSURL getURLByResolvingSymlinksInPath();

    public URL toURL() throws MalformedURLException {
        return new URL(this.getAbsoluteString());
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.getAbsoluteString());
    }

    public static String encodeURLString(String urlString, NSStringEncoding encoding) {
        return new NSString(urlString).addPercentEscapes(encoding);
    }

    public static String decodeURLString(String urlString, NSStringEncoding encoding) {
        return new NSString(urlString).replacePercentEscapes(encoding);
    }

    public NSObject getResourceValue(NSURLFileSystemProperty property) throws NSErrorException {
        return this.getResourceValue(property.value());
    }

    public NSObject getResourceValue(NSURLFileProperty property) throws NSErrorException {
        return this.getResourceValue(property.value());
    }

    public NSObject getResourceValue(NSURLVolumeProperty property) throws NSErrorException {
        return this.getResourceValue(property.value());
    }

    public NSObject getResourceValue(NSURLUbiquitousItemProperty property) throws NSErrorException {
        return this.getResourceValue(property.value());
    }

    private NSObject getResourceValue(NSString key) throws NSErrorException {
        NSObject.NSObjectPtr value = new NSObject.NSObjectPtr();
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        this.getResourceValue(value, key, err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
        return (NSObject)value.get();
    }

    public void removeCachedResourceValue(NSURLFileSystemProperty property) {
        this.removeCachedResourceValue(property.value());
    }

    public void removeCachedResourceValue(NSURLFileProperty property) {
        this.removeCachedResourceValue(property.value());
    }

    public void removeCachedResourceValue(NSURLVolumeProperty property) {
        this.removeCachedResourceValue(property.value());
    }

    public void removeCachedResourceValue(NSURLUbiquitousItemProperty property) {
        this.removeCachedResourceValue(property.value());
    }

    public void setResourceValue(NSURLFileSystemProperty property, NSObject value) throws NSErrorException {
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        this.setResourceValue(value, property.value(), err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
    }

    public void setResourceValue(NSURLFileProperty property, NSObject value) throws NSErrorException {
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        this.setResourceValue(value, property.value(), err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
    }

    public void setResourceValue(NSURLVolumeProperty property, NSObject value) throws NSErrorException {
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        this.setResourceValue(value, property.value(), err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
    }

    public void setResourceValue(NSURLUbiquitousItemProperty property, NSObject value) throws NSErrorException {
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        this.setResourceValue(value, property.value(), err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
    }

    public void setTemporaryResourceValue(NSURLFileSystemProperty property, NSObject value) {
        this.setTemporaryResourceValue(value, property.value());
    }

    public void setTemporaryResourceValue(NSURLFileProperty property, NSObject value) {
        this.setTemporaryResourceValue(value, property.value());
    }

    public void setTemporaryResourceValue(NSURLVolumeProperty property, NSObject value) {
        this.setTemporaryResourceValue(value, property.value());
    }

    public void setTemporaryResourceValue(NSURLUbiquitousItemProperty property, NSObject value) {
        this.setTemporaryResourceValue(value, property.value());
    }

    public NSObject getPromisedItemResourceValue(NSURLProperty key) throws NSErrorException {
        NSObject.NSObjectPtr ptr = new NSObject.NSObjectPtr();
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        if (this.getPromisedItemResourceValue(ptr, key.value(), err)) {
            return (NSObject)ptr.get();
        }
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
        return null;
    }

    @Method(selector="initWithScheme:host:path:")
    @Pointer
    protected native long init(String var1, String var2, String var3);

    @Method(selector="initFileURLWithPath:isDirectory:")
    @Pointer
    protected native long initFileURL(String var1, boolean var2);

    @Method(selector="initFileURLWithPath:")
    @Pointer
    protected native long initFileURL(String var1);

    @Method(selector="initWithString:")
    @Pointer
    protected native long init(String var1);

    @Method(selector="initWithString:relativeToURL:")
    @Pointer
    protected native long init(String var1, NSURL var2);

    public boolean checkResourceIsReachable() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.checkResourceIsReachable(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="checkResourceIsReachableAndReturnError:")
    private native boolean checkResourceIsReachable(NSError.NSErrorPtr var1);

    @Method(selector="isFileReferenceURL")
    public native boolean isFileReferenceURL();

    @Method(selector="fileReferenceURL")
    public native NSURL getFileReferenceURL();

    @Method(selector="getResourceValue:forKey:error:")
    private native boolean getResourceValue(NSObject.NSObjectPtr var1, NSString var2, NSError.NSErrorPtr var3);

    public NSURLProperties getResourceValues(@Marshaler(value=NSURLProperty.AsListMarshaler.class) List<NSURLProperty> keys) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSURLProperties result = this.getResourceValues(keys, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="resourceValuesForKeys:error:")
    private native NSURLProperties getResourceValues(@Marshaler(value=NSURLProperty.AsListMarshaler.class) List<NSURLProperty> var1, NSError.NSErrorPtr var2);

    public boolean setResourceValue(NSObject value, NSString key) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setResourceValue(value, key, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setResourceValue:forKey:error:")
    private native boolean setResourceValue(NSObject var1, NSString var2, NSError.NSErrorPtr var3);

    public boolean setResourceValues(NSURLProperties keyedValues) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setResourceValues(keyedValues, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setResourceValues:error:")
    private native boolean setResourceValues(NSURLProperties var1, NSError.NSErrorPtr var2);

    @Method(selector="removeCachedResourceValueForKey:")
    protected native void removeCachedResourceValue(NSString var1);

    @Method(selector="removeAllCachedResourceValues")
    public native void removeAllCachedResourceValues();

    @Method(selector="setTemporaryResourceValue:forKey:")
    protected native void setTemporaryResourceValue(NSObject var1, NSString var2);

    public NSData toBookmarkData(NSURLBookmarkCreationOptions options, @Marshaler(value=NSURLProperty.AsListMarshaler.class) List<NSURLProperty> keys, NSURL relativeURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.toBookmarkData(options, keys, relativeURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="bookmarkDataWithOptions:includingResourceValuesForKeys:relativeToURL:error:")
    private native NSData toBookmarkData(NSURLBookmarkCreationOptions var1, @Marshaler(value=NSURLProperty.AsListMarshaler.class) List<NSURLProperty> var2, NSURL var3, NSError.NSErrorPtr var4);

    @Method(selector="initByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:")
    @Pointer
    private native long init(NSData var1, NSURLBookmarkResolutionOptions var2, NSURL var3, BooleanPtr var4, NSError.NSErrorPtr var5);

    @Method(selector="startAccessingSecurityScopedResource")
    public native boolean startAccessingSecurityScopedResource();

    @Method(selector="stopAccessingSecurityScopedResource")
    public native void stopAccessingSecurityScopedResource();

    @Method(selector="resourceValuesForKeys:fromBookmarkData:")
    public static native NSURLProperties getResourceValuesFromBookmarkData(@Marshaler(value=NSURLProperty.AsListMarshaler.class) List<NSURLProperty> var0, NSData var1);

    public static boolean writeBookmarkData(NSData bookmarkData, NSURL bookmarkFileURL, NSURLBookmarkCreationOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSURL.writeBookmarkData(bookmarkData, bookmarkFileURL, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeBookmarkData:toURL:options:error:")
    private static native boolean writeBookmarkData(NSData var0, NSURL var1, NSURLBookmarkCreationOptions var2, NSError.NSErrorPtr var3);

    public static NSData createBookmarkData(NSURL bookmarkFileURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = NSURL.createBookmarkData(bookmarkFileURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="bookmarkDataWithContentsOfURL:error:")
    private static native NSData createBookmarkData(NSURL var0, NSError.NSErrorPtr var1);

    public boolean getPromisedItemResourceValue(NSObject.NSObjectPtr value, NSString key) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.getPromisedItemResourceValue(value, key, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="getPromisedItemResourceValue:forKey:error:")
    private native boolean getPromisedItemResourceValue(NSObject.NSObjectPtr var1, NSString var2, NSError.NSErrorPtr var3);

    public NSURLProperties getPromisedItemResourceValues(@Marshaler(value=NSURLProperty.AsListMarshaler.class) List<NSURLProperty> keys) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSURLProperties result = this.getPromisedItemResourceValues(keys, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="promisedItemResourceValuesForKeys:error:")
    private native NSURLProperties getPromisedItemResourceValues(@Marshaler(value=NSURLProperty.AsListMarshaler.class) List<NSURLProperty> var1, NSError.NSErrorPtr var2);

    public boolean isPromisedItemReachable() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.isPromisedItemReachable(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="checkPromisedItemIsReachableAndReturnError:")
    private native boolean isPromisedItemReachable(NSError.NSErrorPtr var1);

    @Method(selector="URLByAppendingPathComponent:")
    public native NSURL newURLByAppendingPathComponent(String var1);

    @Method(selector="URLByAppendingPathComponent:isDirectory:")
    public native NSURL newURLByAppendingPathComponent(String var1, boolean var2);

    @Method(selector="URLByAppendingPathExtension:")
    public native NSURL newURLByAppendingPathExtension(String var1);

    static {
        ObjCRuntime.bind(NSURL.class);
    }

    public static class NSURLPtr
    extends Ptr<NSURL, NSURLPtr> {
    }
}

