/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.lang.reflect.Field;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMTextMarkupAttributes;
import org.robovm.apple.coretext.CTAttributedStringAttributes;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSCharacterSet;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSPropertyList;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSStringEncoding;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.apple.uikit.NSLineBreakMode;
import org.robovm.apple.uikit.NSStringDrawingContext;
import org.robovm.apple.uikit.NSStringDrawingOptions;
import org.robovm.apple.uikit.NSStringExtensions;
import org.robovm.apple.uikit.NSTextAlignment;
import org.robovm.apple.uikit.UIBaselineAdjustment;
import org.robovm.apple.uikit.UIFont;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.AfterBridgeCall;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSString
extends NSObject
implements NSPropertyList {
    private static final String EMPTY_STRING = "";
    private static final long STRING_VALUE_OFFSET;
    private static final long STRING_OFFSET_OFFSET;
    private static final Selector sel_length;
    private static final Selector sel_getCharacters;
    private static final Selector sel_hasPrefix$;
    private static final Selector sel_hasSuffix$;
    private static final Selector sel_dataUsingEncoding$allowLossyConversion$;
    private static final Selector sel_dataUsingEncoding$;
    private static final Selector sel_stringByAppendingPathComponent$;
    private static final Selector sel_stringByAppendingPathExtension$;
    private static final Selector sel_stringByAddingPercentEncodingWithAllowedCharacters$;
    private static final Selector sel_stringByAddingPercentEscapesUsingEncoding$;
    private static final Selector sel_stringByReplacingPercentEscapesUsingEncoding$;
    private static final Selector sel_rangeOfString$;

    public NSString(String s) {
        super(null);
        this.initObject(this.init(NSString.getChars(s), s.length()));
    }

    public NSString() {
    }

    protected NSString(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="length")
    @MachineSizedUInt
    protected native long length();

    private static long getChars(String s) {
        int offset = VM.getInt((long)(VM.getObjectAddress((Object)s) + STRING_OFFSET_OFFSET));
        char[] value = (char[])VM.getObject((long)(VM.getObjectAddress((Object)s) + STRING_VALUE_OFFSET));
        return VM.getArrayValuesAddress((Object)value) + (long)(offset << 1);
    }

    @Override
    public String toString() {
        int len = (int)this.length();
        if (len == 0) {
            return EMPTY_STRING;
        }
        char[] chars = new char[len];
        this.getCharacters(VM.getArrayValuesAddress((Object)chars), new NSRange(0L, len));
        return VM.newStringNoCopy((char[])chars, (int)0, (int)len);
    }

    @Bridge
    @MachineSizedUInt
    protected static native long length(@Pointer long var0, Selector var2);

    @Bridge
    protected static native void getCharacters(@Pointer long var0, Selector var2, @Pointer long var3, @ByVal NSRange var5);

    public static String getLocalizedString(String key) {
        return NSBundle.getMainBundle().getLocalizedString(key, EMPTY_STRING, null);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize getSize(UIFont font) {
        return NSStringExtensions.getSize(this.getHandle(), font);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize getSize(UIFont font, @MachineSizedFloat double width, NSLineBreakMode lineBreakMode) {
        return NSStringExtensions.getSize(this.getHandle(), font, width, lineBreakMode);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize draw(CGPoint point, UIFont font) {
        return NSStringExtensions.draw(this.getHandle(), point, font);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize draw(CGPoint point, @MachineSizedFloat double width, UIFont font, NSLineBreakMode lineBreakMode) {
        return NSStringExtensions.draw(this.getHandle(), point, width, font, lineBreakMode);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize getSize(UIFont font, @ByVal CGSize size) {
        return NSStringExtensions.getSize(this.getHandle(), font, size);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize getSize(UIFont font, @ByVal CGSize size, NSLineBreakMode lineBreakMode) {
        return NSStringExtensions.getSize(this.getHandle(), font, size, lineBreakMode);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize draw(@ByVal CGRect rect, UIFont font) {
        return NSStringExtensions.draw(this.getHandle(), rect, font);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize draw(NSString thiz, @ByVal CGRect rect, UIFont font, NSLineBreakMode lineBreakMode) {
        return NSStringExtensions.draw(this.getHandle(), rect, font, lineBreakMode);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize draw(CGRect rect, UIFont font, NSLineBreakMode lineBreakMode, NSTextAlignment alignment) {
        return NSStringExtensions.draw(this.getHandle(), rect, font, lineBreakMode, alignment);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize getSize(UIFont font, @MachineSizedFloat double minFontSize, @MachineSizedFloat double width, NSLineBreakMode lineBreakMode) {
        return NSStringExtensions.getSize(this.getHandle(), font, minFontSize, null, width, lineBreakMode);
    }

    @Deprecated
    @WeaklyLinked
    public CGSize draw(CGPoint point, @MachineSizedFloat double width, UIFont font, @MachineSizedFloat double fontSize, NSLineBreakMode lineBreakMode, UIBaselineAdjustment baselineAdjustment) {
        return NSStringExtensions.draw(this.getHandle(), point, width, font, fontSize, lineBreakMode, baselineAdjustment);
    }

    @WeaklyLinked
    public CGSize getSize(NSDictionary<NSString, NSObject> attrs) {
        return NSStringExtensions.getSize(this.getHandle(), attrs);
    }

    @WeaklyLinked
    public CGSize getSize(NSAttributedStringAttributes attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        return NSStringExtensions.getSize(this.getHandle(), attrs.getDictionary());
    }

    @WeaklyLinked
    public CGSize getSize(CMTextMarkupAttributes attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        return NSStringExtensions.getSize(this.getHandle(), (NSDictionary)attrs.getDictionary().as(NSDictionary.class));
    }

    @WeaklyLinked
    public CGSize getSize(CTAttributedStringAttributes attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        return NSStringExtensions.getSize(this.getHandle(), (NSDictionary)attrs.getDictionary().as(NSDictionary.class));
    }

    @WeaklyLinked
    public static CGSize getSize(String str, NSDictionary<NSString, NSObject> attrs) {
        return NSStringExtensions.getSize(NSString.create(NSString.getChars(str), str.length()), attrs);
    }

    @WeaklyLinked
    public static CGSize getSize(String str, NSAttributedStringAttributes attrs) {
        return NSStringExtensions.getSize(NSString.create(NSString.getChars(str), str.length()), attrs.getDictionary());
    }

    @WeaklyLinked
    public static CGSize getSize(String str, CMTextMarkupAttributes attrs) {
        return NSStringExtensions.getSize(NSString.create(NSString.getChars(str), str.length()), (NSDictionary)attrs.getDictionary().as(NSDictionary.class));
    }

    @WeaklyLinked
    public static CGSize getSize(String str, CTAttributedStringAttributes attrs) {
        return NSStringExtensions.getSize(NSString.create(NSString.getChars(str), str.length()), (NSDictionary)attrs.getDictionary().as(NSDictionary.class));
    }

    @WeaklyLinked
    public void draw(CGPoint point, NSDictionary<NSString, NSObject> attrs) {
        NSStringExtensions.draw(this.getHandle(), point, attrs);
    }

    @WeaklyLinked
    public void draw(CGPoint point, NSAttributedStringAttributes attrs) {
        if (attrs == null) {
            NSStringExtensions.draw(this.getHandle(), point, (NSDictionary<NSString, NSObject>)null);
        } else {
            NSStringExtensions.draw(this.getHandle(), point, attrs.getDictionary());
        }
    }

    @WeaklyLinked
    public void draw(CGPoint point, CMTextMarkupAttributes attrs) {
        if (attrs == null) {
            NSStringExtensions.draw(this.getHandle(), point, (NSDictionary<NSString, NSObject>)null);
        } else {
            NSStringExtensions.draw(this.getHandle(), point, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
        }
    }

    @WeaklyLinked
    public void draw(CGPoint point, CTAttributedStringAttributes attrs) {
        if (attrs == null) {
            NSStringExtensions.draw(this.getHandle(), point, (NSDictionary<NSString, NSObject>)null);
        } else {
            NSStringExtensions.draw(this.getHandle(), point, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
        }
    }

    @WeaklyLinked
    public static void draw(String str, CGPoint point, NSDictionary<NSString, NSObject> attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), point, attrs);
    }

    @WeaklyLinked
    public static void draw(String str, CGPoint point, NSAttributedStringAttributes attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), point, attrs.getDictionary());
    }

    @WeaklyLinked
    public static void draw(String str, CGPoint point, CMTextMarkupAttributes attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), point, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
    }

    @WeaklyLinked
    public static void draw(String str, CGPoint point, CTAttributedStringAttributes attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), point, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
    }

    @WeaklyLinked
    public void draw(CGRect rect, NSDictionary<NSString, NSObject> attrs) {
        NSStringExtensions.draw(this.getHandle(), rect, attrs);
    }

    @WeaklyLinked
    public void draw(CGRect rect, NSAttributedStringAttributes attrs) {
        if (attrs == null) {
            NSStringExtensions.draw(this.getHandle(), rect, (NSDictionary<NSString, NSObject>)null);
        } else {
            NSStringExtensions.draw(this.getHandle(), rect, attrs.getDictionary());
        }
    }

    @WeaklyLinked
    public void draw(CGRect rect, CMTextMarkupAttributes attrs) {
        if (attrs == null) {
            NSStringExtensions.draw(this.getHandle(), rect, (NSDictionary<NSString, NSObject>)null);
        } else {
            NSStringExtensions.draw(this.getHandle(), rect, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
        }
    }

    @WeaklyLinked
    public void draw(CGRect rect, CTAttributedStringAttributes attrs) {
        if (attrs == null) {
            NSStringExtensions.draw(this.getHandle(), rect, (NSDictionary<NSString, NSObject>)null);
        } else {
            NSStringExtensions.draw(this.getHandle(), rect, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
        }
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, NSDictionary<NSString, NSObject> attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, attrs);
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, NSAttributedStringAttributes attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, attrs.getDictionary());
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, CMTextMarkupAttributes attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, CTAttributedStringAttributes attrs) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, (NSDictionary<NSString, NSObject>)((NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
    }

    @WeaklyLinked
    public void draw(CGRect rect, NSStringDrawingOptions options, NSDictionary<NSString, NSObject> attributes, NSStringDrawingContext context) {
        NSStringExtensions.draw(this.getHandle(), rect, options, attributes, context);
    }

    @WeaklyLinked
    public void draw(CGRect rect, NSStringDrawingOptions options, NSAttributedStringAttributes attributes, NSStringDrawingContext context) {
        if (attributes == null) {
            NSStringExtensions.draw(this.getHandle(), rect, options, null, context);
        } else {
            NSStringExtensions.draw(this.getHandle(), rect, options, attributes.getDictionary(), context);
        }
    }

    @WeaklyLinked
    public void draw(CGRect rect, NSStringDrawingOptions options, CMTextMarkupAttributes attributes, NSStringDrawingContext context) {
        if (attributes == null) {
            NSStringExtensions.draw(this.getHandle(), rect, options, null, context);
        } else {
            NSStringExtensions.draw(this.getHandle(), rect, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
        }
    }

    @WeaklyLinked
    public void draw(CGRect rect, NSStringDrawingOptions options, CTAttributedStringAttributes attributes, NSStringDrawingContext context) {
        if (attributes == null) {
            NSStringExtensions.draw(this.getHandle(), rect, options, null, context);
        } else {
            NSStringExtensions.draw(this.getHandle(), rect, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
        }
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, NSStringDrawingOptions options, NSDictionary<NSString, NSObject> attributes, NSStringDrawingContext context) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, options, attributes, context);
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, NSStringDrawingOptions options, NSAttributedStringAttributes attributes, NSStringDrawingContext context) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, options, attributes.getDictionary(), context);
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, NSStringDrawingOptions options, CMTextMarkupAttributes attributes, NSStringDrawingContext context) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
    }

    @WeaklyLinked
    public static void draw(String str, CGRect rect, NSStringDrawingOptions options, CTAttributedStringAttributes attributes, NSStringDrawingContext context) {
        NSStringExtensions.draw(NSString.create(NSString.getChars(str), str.length()), rect, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
    }

    @WeaklyLinked
    public CGRect getBoundingRect(CGSize size, NSStringDrawingOptions options, NSDictionary<NSString, NSObject> attributes, NSStringDrawingContext context) {
        return NSStringExtensions.getBoundingRect(this.getHandle(), size, options, attributes, context);
    }

    @WeaklyLinked
    public CGRect getBoundingRect(CGSize size, NSStringDrawingOptions options, NSAttributedStringAttributes attributes, NSStringDrawingContext context) {
        if (attributes == null) {
            return NSStringExtensions.getBoundingRect(this.getHandle(), size, options, null, context);
        }
        return NSStringExtensions.getBoundingRect(this.getHandle(), size, options, attributes.getDictionary(), context);
    }

    @WeaklyLinked
    public CGRect getBoundingRect(CGSize size, NSStringDrawingOptions options, CMTextMarkupAttributes attributes, NSStringDrawingContext context) {
        if (attributes == null) {
            return NSStringExtensions.getBoundingRect(this.getHandle(), size, options, null, context);
        }
        return NSStringExtensions.getBoundingRect(this.getHandle(), size, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
    }

    @WeaklyLinked
    public CGRect getBoundingRect(CGSize size, NSStringDrawingOptions options, CTAttributedStringAttributes attributes, NSStringDrawingContext context) {
        if (attributes == null) {
            return NSStringExtensions.getBoundingRect(this.getHandle(), size, options, null, context);
        }
        return NSStringExtensions.getBoundingRect(this.getHandle(), size, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
    }

    @WeaklyLinked
    public static CGRect getBoundingRect(String str, CGSize size, NSStringDrawingOptions options, NSDictionary<NSString, NSObject> attributes, NSStringDrawingContext context) {
        return NSStringExtensions.getBoundingRect(NSString.create(NSString.getChars(str), str.length()), size, options, attributes, context);
    }

    @WeaklyLinked
    public static CGRect getBoundingRect(String str, CGSize size, NSStringDrawingOptions options, NSAttributedStringAttributes attributes, NSStringDrawingContext context) {
        return NSStringExtensions.getBoundingRect(NSString.create(NSString.getChars(str), str.length()), size, options, attributes.getDictionary(), context);
    }

    @WeaklyLinked
    public static CGRect getBoundingRect(String str, CGSize size, NSStringDrawingOptions options, CMTextMarkupAttributes attributes, NSStringDrawingContext context) {
        return NSStringExtensions.getBoundingRect(NSString.create(NSString.getChars(str), str.length()), size, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
    }

    @WeaklyLinked
    public static CGRect getBoundingRect(String str, CGSize size, NSStringDrawingOptions options, CTAttributedStringAttributes attributes, NSStringDrawingContext context) {
        return NSStringExtensions.getBoundingRect(NSString.create(NSString.getChars(str), str.length()), size, options, (NSDictionary)attributes.getDictionary().as(NSDictionary.class), context);
    }

    public static String readFile(File path, NSStringEncoding enc) throws NSErrorException {
        return NSString.readFile(path.getAbsolutePath(), enc);
    }

    @Bridge
    protected static native String hasPrefix(@Pointer long var0, Selector var2, String var3);

    public static String hasPrefix(String str, String prefix) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.hasPrefix(handle, sel_hasPrefix$, prefix);
    }

    @Bridge
    protected static native String hasSuffix(@Pointer long var0, Selector var2, String var3);

    public static String hasSuffix(String str, String suffix) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.hasSuffix(handle, sel_hasSuffix$, suffix);
    }

    @Bridge
    protected static native NSData toData(@Pointer long var0, Selector var2, NSStringEncoding var3, boolean var4);

    public static NSData toData(String str, NSStringEncoding encoding, boolean lossy) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.toData(handle, sel_dataUsingEncoding$allowLossyConversion$, encoding, lossy);
    }

    @Bridge
    protected static native NSData toData(@Pointer long var0, Selector var2, NSStringEncoding var3);

    public static NSData toData(String str, NSStringEncoding encoding) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.toData(handle, sel_dataUsingEncoding$, encoding);
    }

    @Bridge
    protected static native String appendPathComponent(@Pointer long var0, Selector var2, String var3);

    public static String appendPathComponent(String str, String component) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.appendPathComponent(handle, sel_stringByAppendingPathComponent$, component);
    }

    @Bridge
    protected static native String appendPathExtension(@Pointer long var0, Selector var2, String var3);

    public static String appendPathExtension(String str, String extension) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.appendPathExtension(handle, sel_stringByAppendingPathExtension$, extension);
    }

    @Bridge
    protected static native String addPercentEncoding(@Pointer long var0, Selector var2, NSCharacterSet var3);

    public static String addPercentEncoding(String str, NSCharacterSet allowedCharacters) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.addPercentEncoding(handle, sel_stringByAddingPercentEncodingWithAllowedCharacters$, allowedCharacters);
    }

    @Bridge
    protected static native String addPercentEscapes(@Pointer long var0, Selector var2, NSStringEncoding var3);

    public static String addPercentEscapes(String str, NSStringEncoding encoding) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.addPercentEscapes(handle, sel_stringByAddingPercentEscapesUsingEncoding$, encoding);
    }

    @Bridge
    protected static native String replacePercentEscapes(@Pointer long var0, Selector var2, NSStringEncoding var3);

    public static String replacePercentEscapes(String str, NSStringEncoding encoding) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.replacePercentEscapes(handle, sel_stringByReplacingPercentEscapesUsingEncoding$, encoding);
    }

    @Bridge
    @ByVal
    protected static native NSRange rangeOf(@Pointer long var0, Selector var2, String var3);

    public static NSRange rangeOf(String str, String search) {
        long handle = NSString.create(NSString.getChars(str), str.length());
        return NSString.rangeOf(handle, sel_rangeOfString$, search);
    }

    @Method(selector="characterAtIndex:")
    protected native short getCharactersAt(@MachineSizedUInt long var1);

    @Method(selector="getCharacters:range:")
    protected native void getCharacters(@Pointer long var1, @ByVal NSRange var3);

    @Method(selector="hasPrefix:")
    public native boolean hasPrefix(String var1);

    @Method(selector="hasSuffix:")
    public native boolean hasSuffix(String var1);

    @Method(selector="dataUsingEncoding:allowLossyConversion:")
    public native NSData toData(NSStringEncoding var1, boolean var2);

    @Method(selector="dataUsingEncoding:")
    public native NSData toData(NSStringEncoding var1);

    @Method(selector="initWithCharacters:length:")
    @Pointer
    protected native long init(@Pointer long var1, @MachineSizedUInt long var3);

    public boolean writeURL(NSURL url, boolean useAuxiliaryFile, NSStringEncoding enc) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeURL(url, useAuxiliaryFile, enc, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeToURL:atomically:encoding:error:")
    private native boolean writeURL(NSURL var1, boolean var2, NSStringEncoding var3, NSError.NSErrorPtr var4);

    public boolean writeFile(String path, boolean useAuxiliaryFile, NSStringEncoding enc) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeFile(path, useAuxiliaryFile, enc, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeToFile:atomically:encoding:error:")
    private native boolean writeFile(String var1, boolean var2, NSStringEncoding var3, NSError.NSErrorPtr var4);

    @Method(selector="stringWithCharacters:length:")
    @Pointer
    protected static native long create(@Pointer long var0, @MachineSizedUInt long var2);

    public static String readURL(NSURL url, NSStringEncoding enc) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        String result = NSString.readURL(url, enc, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="stringWithContentsOfURL:encoding:error:")
    private static native String readURL(NSURL var0, NSStringEncoding var1, NSError.NSErrorPtr var2);

    public static String readFile(String path, NSStringEncoding enc) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        String result = NSString.readFile(path, enc, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="stringWithContentsOfFile:encoding:error:")
    private static native String readFile(String var0, NSStringEncoding var1, NSError.NSErrorPtr var2);

    @Method(selector="stringByAppendingPathComponent:")
    public native String appendPathComponent(String var1);

    @Method(selector="stringByAppendingPathExtension:")
    public native String appendPathExtension(String var1);

    @Method(selector="stringByAddingPercentEncodingWithAllowedCharacters:")
    public native String addPercentEncoding(NSCharacterSet var1);

    @Method(selector="stringByAddingPercentEscapesUsingEncoding:")
    public native String addPercentEscapes(NSStringEncoding var1);

    @Method(selector="stringByReplacingPercentEscapesUsingEncoding:")
    public native String replacePercentEscapes(NSStringEncoding var1);

    static {
        sel_length = Selector.register((String)"length");
        sel_getCharacters = Selector.register((String)"getCharacters:range:");
        ObjCRuntime.bind(NSString.class);
        try {
            STRING_VALUE_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)String.class.getDeclaredField("value")));
            STRING_OFFSET_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)String.class.getDeclaredField("offset")));
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        sel_hasPrefix$ = Selector.register((String)"hasPrefix:");
        sel_hasSuffix$ = Selector.register((String)"hasSuffix:");
        sel_dataUsingEncoding$allowLossyConversion$ = Selector.register((String)"dataUsingEncoding:allowLossyConversion:");
        sel_dataUsingEncoding$ = Selector.register((String)"dataUsingEncoding:");
        sel_stringByAppendingPathComponent$ = Selector.register((String)"stringByAppendingPathComponent:");
        sel_stringByAppendingPathExtension$ = Selector.register((String)"stringByAppendingPathExtension:");
        sel_stringByAddingPercentEncodingWithAllowedCharacters$ = Selector.register((String)"stringByAddingPercentEncodingWithAllowedCharacters:");
        sel_stringByAddingPercentEscapesUsingEncoding$ = Selector.register((String)"stringByAddingPercentEscapesUsingEncoding:");
        sel_stringByReplacingPercentEscapesUsingEncoding$ = Selector.register((String)"stringByReplacingPercentEscapesUsingEncoding:");
        sel_rangeOfString$ = Selector.register((String)"rangeOfString:");
    }

    public static class AsStringMarshaler {
        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            if (handle != 0L) {
                long length = NSString.length(handle, sel_length);
                if (length == 0L) {
                    return NSString.EMPTY_STRING;
                }
                char[] chars = new char[(int)length];
                NSString.getCharacters(handle, sel_getCharacters, VM.getArrayValuesAddress((Object)chars), new NSRange(0L, length));
                return VM.newStringNoCopy((char[])chars, (int)0, (int)((int)length));
            }
            return null;
        }

        @MarshalsPointer
        public static long toNative(String o, long flags) {
            if (o == null) {
                return 0L;
            }
            long handle = NSString.create(NSString.getChars(o), o.length());
            NSObject.retain(handle);
            if ((flags & 1L) > 0L) {
                NSObject.autorelease(handle);
            }
            return handle;
        }

        @AfterBridgeCall
        public static void afterJavaToNative(String before, long after, long flags) {
            if (after != 0L) {
                NSObject.release(after);
            }
        }
    }

    public static class NSStringPtr
    extends Ptr<NSString, NSStringPtr> {
    }
}

