/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSStreamSOCKSProxyVersion;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSStreamSOCKSProxyConfiguration
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected NSStreamSOCKSProxyConfiguration(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSStreamSOCKSProxyConfiguration() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public String getHost() {
        if (this.data.containsKey(NSStreamSOCKSProxyConfiguration.HostKey())) {
            NSString val = (NSString)this.data.get(NSStreamSOCKSProxyConfiguration.HostKey());
            return val.toString();
        }
        return null;
    }

    public NSStreamSOCKSProxyConfiguration setHost(String host) {
        this.data.put(NSStreamSOCKSProxyConfiguration.HostKey(), new NSString(host));
        return this;
    }

    public int getPort() {
        if (this.data.containsKey(NSStreamSOCKSProxyConfiguration.PortKey())) {
            NSNumber val = (NSNumber)this.data.get(NSStreamSOCKSProxyConfiguration.PortKey());
            return val.intValue();
        }
        return 0;
    }

    public NSStreamSOCKSProxyConfiguration setPort(int port) {
        this.data.put(NSStreamSOCKSProxyConfiguration.PortKey(), NSNumber.valueOf(port));
        return this;
    }

    public NSStreamSOCKSProxyVersion getVersion() {
        if (this.data.containsKey(NSStreamSOCKSProxyConfiguration.VersionKey())) {
            NSString val = (NSString)this.data.get(NSStreamSOCKSProxyConfiguration.VersionKey());
            return NSStreamSOCKSProxyVersion.valueOf(val);
        }
        return null;
    }

    public NSStreamSOCKSProxyConfiguration setVersion(NSStreamSOCKSProxyVersion version) {
        this.data.put(NSStreamSOCKSProxyConfiguration.VersionKey(), version.value());
        return this;
    }

    public String getUser() {
        if (this.data.containsKey(NSStreamSOCKSProxyConfiguration.UserKey())) {
            NSString val = (NSString)this.data.get(NSStreamSOCKSProxyConfiguration.UserKey());
            return val.toString();
        }
        return null;
    }

    public NSStreamSOCKSProxyConfiguration setUser(String host) {
        this.data.put(NSStreamSOCKSProxyConfiguration.UserKey(), new NSString(host));
        return this;
    }

    public String getPassword() {
        if (this.data.containsKey(NSStreamSOCKSProxyConfiguration.PasswordKey())) {
            NSString val = (NSString)this.data.get(NSStreamSOCKSProxyConfiguration.PasswordKey());
            return val.toString();
        }
        return null;
    }

    public NSStreamSOCKSProxyConfiguration setPassword(String host) {
        this.data.put(NSStreamSOCKSProxyConfiguration.PasswordKey(), new NSString(host));
        return this;
    }

    @GlobalValue(symbol="NSStreamSOCKSProxyHostKey", optional=true)
    protected static native NSString HostKey();

    @GlobalValue(symbol="NSStreamSOCKSProxyPortKey", optional=true)
    protected static native NSString PortKey();

    @GlobalValue(symbol="NSStreamSOCKSProxyVersionKey", optional=true)
    protected static native NSString VersionKey();

    @GlobalValue(symbol="NSStreamSOCKSProxyUserKey", optional=true)
    protected static native NSString UserKey();

    @GlobalValue(symbol="NSStreamSOCKSProxyPasswordKey", optional=true)
    protected static native NSString PasswordKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSStreamSOCKSProxyConfiguration.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSStreamSOCKSProxyConfiguration toObject(Class<NSStreamSOCKSProxyConfiguration> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSStreamSOCKSProxyConfiguration(o);
        }

        @MarshalsPointer
        public static long toNative(NSStreamSOCKSProxyConfiguration o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

