/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSInputStream;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOutputStream;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSStreamDelegate;
import org.robovm.apple.foundation.NSStreamNetworkServiceType;
import org.robovm.apple.foundation.NSStreamProperty;
import org.robovm.apple.foundation.NSStreamSOCKSProxyConfiguration;
import org.robovm.apple.foundation.NSStreamSocketSecurityLevel;
import org.robovm.apple.foundation.NSStreamStatus;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSStream
extends NSObject {
    public NSStream() {
    }

    protected NSStream(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="delegate")
    public native NSStreamDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(NSStreamDelegate var1);

    @Property(selector="streamStatus")
    public native NSStreamStatus getStreamStatus();

    @Property(selector="streamError")
    public native NSError getStreamError();

    public void setProperty(NSStreamProperty key, NSObject value) {
        this.setProperty(value, key);
    }

    public NSStreamSocketSecurityLevel getSocketSecurityLevel() {
        NSString val = (NSString)this.getProperty(NSStreamProperty.SocketSecurityLevel);
        return NSStreamSocketSecurityLevel.valueOf(val);
    }

    public NSStream setSocketSecurityLevel(NSStreamSocketSecurityLevel securityLevel) {
        this.setProperty(NSStreamProperty.SocketSecurityLevel, securityLevel.value());
        return this;
    }

    public NSStreamSOCKSProxyConfiguration getSOCKSProxyConfiguration() {
        NSDictionary val = (NSDictionary)this.getProperty(NSStreamProperty.SOCKSProxyConfiguration);
        return new NSStreamSOCKSProxyConfiguration(val);
    }

    public NSStream setSOCKSProxyConfiguration(NSStreamSOCKSProxyConfiguration configuration) {
        this.setProperty(NSStreamProperty.SOCKSProxyConfiguration, configuration.getDictionary());
        return this;
    }

    public NSData getDataWrittenToMemoryStream() {
        NSData val = (NSData)this.getProperty(NSStreamProperty.DataWrittenToMemoryStream);
        return val;
    }

    public NSStream setDataWrittenToMemoryStream(NSData data) {
        this.setProperty(NSStreamProperty.DataWrittenToMemoryStream, data);
        return this;
    }

    public long getCurrentOffset() {
        NSNumber val = (NSNumber)this.getProperty(NSStreamProperty.FileCurrentOffset);
        return val.longValue();
    }

    public NSStream setCurrentOffset(long offset) {
        this.setProperty(NSStreamProperty.FileCurrentOffset, NSNumber.valueOf(offset));
        return this;
    }

    public NSStreamNetworkServiceType getNetworkServiceType() {
        NSString val = (NSString)this.getProperty(NSStreamProperty.NetworkServiceType);
        return NSStreamNetworkServiceType.valueOf(val);
    }

    public NSStream setNetworkServiceType(NSStreamNetworkServiceType serviceType) {
        this.setProperty(NSStreamProperty.NetworkServiceType, serviceType.value());
        return this;
    }

    public static NSInputStream getInputStreamToHost(String hostname, @MachineSizedSInt long port) {
        NSInputStream.NSInputStreamPtr ptr = new NSInputStream.NSInputStreamPtr();
        NSStream.getStreamsToHost(hostname, port, ptr, new NSOutputStream.NSOutputStreamPtr());
        return (NSInputStream)ptr.get();
    }

    public static NSOutputStream getOutputStreamToHost(String hostname, @MachineSizedSInt long port) {
        NSOutputStream.NSOutputStreamPtr ptr = new NSOutputStream.NSOutputStreamPtr();
        NSStream.getStreamsToHost(hostname, port, new NSInputStream.NSInputStreamPtr(), ptr);
        return (NSOutputStream)ptr.get();
    }

    public static NSInputStream getBoundInputStream(@MachineSizedUInt long bufferSize) {
        NSInputStream.NSInputStreamPtr ptr = new NSInputStream.NSInputStreamPtr();
        NSStream.getBoundStreams(bufferSize, ptr, new NSOutputStream.NSOutputStreamPtr());
        return (NSInputStream)ptr.get();
    }

    public static NSOutputStream getBoundOutputStream(@MachineSizedUInt long bufferSize) {
        NSOutputStream.NSOutputStreamPtr ptr = new NSOutputStream.NSOutputStreamPtr();
        NSStream.getBoundStreams(bufferSize, new NSInputStream.NSInputStreamPtr(), ptr);
        return (NSOutputStream)ptr.get();
    }

    public void scheduleInRunLoop(NSRunLoop aRunLoop, NSRunLoopMode mode) {
        this.scheduleInRunLoop(aRunLoop, mode.value());
    }

    public void removeFromRunLoop(NSRunLoop aRunLoop, NSRunLoopMode mode) {
        this.removeFromRunLoop(aRunLoop, mode.value());
    }

    @Method(selector="open")
    public native void open();

    @Method(selector="close")
    public native void close();

    @Method(selector="propertyForKey:")
    public native NSObject getProperty(NSStreamProperty var1);

    @Method(selector="setProperty:forKey:")
    protected native boolean setProperty(NSObject var1, NSStreamProperty var2);

    @Method(selector="scheduleInRunLoop:forMode:")
    public native void scheduleInRunLoop(NSRunLoop var1, String var2);

    @Method(selector="removeFromRunLoop:forMode:")
    public native void removeFromRunLoop(NSRunLoop var1, String var2);

    @Method(selector="getStreamsToHostWithName:port:inputStream:outputStream:")
    protected static native void getStreamsToHost(String var0, @MachineSizedSInt long var1, NSInputStream.NSInputStreamPtr var3, NSOutputStream.NSOutputStreamPtr var4);

    @Method(selector="getBoundStreamsWithBufferSize:inputStream:outputStream:")
    protected static native void getBoundStreams(@MachineSizedUInt long var0, NSInputStream.NSInputStreamPtr var2, NSOutputStream.NSOutputStreamPtr var3);

    static {
        ObjCRuntime.bind(NSStream.class);
    }

    public static class NSStreamPtr
    extends Ptr<NSStream, NSStreamPtr> {
    }
}

