/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSEnumerator;
import org.robovm.apple.foundation.NSFastEnumeration;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Foundation")
@NativeClass
public class NSSet<T extends NSObject>
extends NSObject
implements NSFastEnumeration,
Set<T> {
    private AbstractSet<T> adapter = this.createAdapter();

    public NSSet() {
    }

    protected NSSet(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSSet(Collection<T> c) {
        super(null);
        if (c instanceof NSArray) {
            this.initObject(this.init((NSArray)c));
        } else if (c instanceof NSSet) {
            this.initObject(this.init((NSSet)c));
        } else {
            NSObject[] objects = c.toArray(new NSObject[c.size()]);
            this.initWithObjects(objects);
        }
    }

    public NSSet(T ... objects) {
        super(null);
        this.initWithObjects((NSObject[])objects);
    }

    @Property(selector="count")
    @MachineSizedUInt
    protected native long getCount();

    @Property(selector="allObjects")
    public native NSArray<T> getValues();

    protected static void checkNull(Object o) {
        if (o == null) {
            throw new NullPointerException("null values are not allowed in NSSet. Use NSNull instead.");
        }
    }

    private void initWithObjects(NSObject[] objects) {
        VoidPtr.VoidPtrPtr ptr = (VoidPtr.VoidPtrPtr)Struct.allocate(VoidPtr.VoidPtrPtr.class, (int)objects.length);
        for (int i = 0; i < objects.length; ++i) {
            NSSet.checkNull(objects[i]);
            ptr.set(objects[i].getHandle());
            ptr = (VoidPtr.VoidPtrPtr)ptr.next();
        }
        ptr = (VoidPtr.VoidPtrPtr)ptr.previous((long)objects.length);
        this.initObject(this.init(ptr.getHandle(), objects.length));
    }

    protected AbstractSet<T> createAdapter() {
        return new SetAdapter(this);
    }

    @Override
    protected void afterMarshaled(int flags) {
        if (this.adapter == null) {
            this.adapter = this.createAdapter();
        }
        super.afterMarshaled(flags);
    }

    @Override
    public boolean add(T e) {
        return this.adapter.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.adapter.addAll(c);
    }

    @Override
    public void clear() {
        this.adapter.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.adapter.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.adapter.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.adapter.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.adapter.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.adapter.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.adapter.retainAll(c);
    }

    @Override
    public int size() {
        return this.adapter.size();
    }

    @Override
    public Object[] toArray() {
        return this.adapter.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.adapter.toArray(a);
    }

    public Set<String> asStringSet() {
        HashSet<String> set = new HashSet<String>();
        if (this.size() == 0) {
            return set;
        }
        if (!(this.any() instanceof NSString)) {
            throw new UnsupportedOperationException("items must be of type NSString");
        }
        for (NSObject str : this) {
            set.add(str.toString());
        }
        return set;
    }

    public List<String> asStringList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.size() == 0) {
            return list;
        }
        if (!(this.any() instanceof NSString)) {
            throw new UnsupportedOperationException("items must be of type NSString");
        }
        for (NSObject str : this) {
            list.add(str.toString());
        }
        return list;
    }

    public static NSSet<NSString> fromStrings(String ... strings) {
        int length = strings.length;
        NSObject[] nsStrings = new NSString[length];
        for (int i = 0; i < length; ++i) {
            nsStrings[i] = new NSString(strings[i]);
        }
        return new NSSet(nsStrings);
    }

    public static NSSet<NSString> fromStrings(Collection<String> strings) {
        NSObject[] nsStrings = new NSString[strings.size()];
        int i = 0;
        for (String s : strings) {
            nsStrings[i] = new NSString(s);
            ++i;
        }
        return new NSSet(nsStrings);
    }

    @Method(selector="member:")
    protected native NSObject isMember(NSObject var1);

    @Method(selector="objectEnumerator")
    protected native NSEnumerator<T> objectEnumerator();

    @Method(selector="initWithObjects:count:")
    @Pointer
    protected native long init(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="anyObject")
    public native T any();

    @Method(selector="initWithSet:")
    @Pointer
    protected native long init(NSSet<?> var1);

    @Method(selector="initWithArray:")
    @Pointer
    protected native long init(NSArray<?> var1);

    static {
        ObjCRuntime.bind(NSSet.class);
    }

    static class SetAdapter<U extends NSObject>
    extends AbstractSet<U> {
        protected final NSSet<U> set;

        SetAdapter(NSSet<U> set) {
            this.set = set;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof NSObject) {
                return this.set.isMember((NSObject)o) != null;
            }
            return false;
        }

        @Override
        public Iterator<U> iterator() {
            return new NSEnumerator.Iterator<U>(this.set.objectEnumerator());
        }

        @Override
        public int size() {
            return (int)this.set.getCount();
        }
    }

    public static class AsStringListMarshaler {
        @MarshalsPointer
        public static List<String> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSSet o = (NSSet)NSObject.Marshaler.toObject(cls, handle, flags);
            return o.asStringList();
        }

        @MarshalsPointer
        public static long toNative(List<String> l, long flags) {
            if (l == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(NSSet.fromStrings(l), flags);
        }
    }

    public static class AsStringSetMarshaler {
        @MarshalsPointer
        public static Set<String> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSSet o = (NSSet)NSObject.Marshaler.toObject(cls, handle, flags);
            return o.asStringSet();
        }

        @MarshalsPointer
        public static long toNative(Set<String> l, long flags) {
            if (l == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(NSSet.fromStrings(l), flags);
        }
    }

    public static class AsSetMarshaler {
        @MarshalsPointer
        public static Set<?> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            return (NSSet)NSObject.Marshaler.toObject(cls, handle, flags);
        }

        @MarshalsPointer
        public static long toNative(Set<?> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSSet o = null;
            o = l instanceof NSSet ? (NSSet)l : new NSSet((Collection<?>)l);
            return NSObject.Marshaler.toNative(o, flags);
        }
    }

    public static class NSSetPtr<T extends NSObject>
    extends Ptr<NSSet<T>, NSSetPtr<T>> {
    }
}

