/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFRunLoop;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSPort;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSTimer;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSRunLoop
extends NSObject {
    public NSRunLoop() {
    }

    protected NSRunLoop(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="currentMode")
    public native String getCurrentMode();

    public void addTimer(String mode, NSTimer timer) {
        this.addTimer0(timer, mode);
    }

    public void addTimer(NSRunLoopMode mode, NSTimer timer) {
        this.addTimer(mode.value(), timer);
    }

    public void addPort(String mode, NSPort port) {
        this.addPort0(port, mode);
    }

    public void addPort(NSRunLoopMode mode, NSPort port) {
        this.addPort0(port, mode.value());
    }

    public void removePort(String mode, NSPort port) {
        this.removePort0(port, mode);
    }

    public void removePort(NSRunLoopMode mode, NSPort port) {
        this.removePort0(port, mode.value());
    }

    public NSDate getDateLimit(NSRunLoopMode mode) {
        return this.getDateLimit(mode.value());
    }

    public void acceptInputUntil(NSRunLoopMode mode, NSDate limitDate) {
        this.acceptInputUntil(mode.value(), limitDate);
    }

    public boolean runUntil(NSRunLoopMode mode, NSDate limitDate) {
        return this.runUntil(mode.value(), limitDate);
    }

    public void perform(Selector aSelector, NSObject target, NSObject arg, @MachineSizedUInt long order, NSRunLoopMode ... modes) {
        ArrayList<String> list = new ArrayList<String>();
        for (NSRunLoopMode mode : modes) {
            list.add(mode.value());
        }
        this.perform(aSelector, target, arg, order, list);
    }

    @Method(selector="getCFRunLoop")
    public native CFRunLoop asCFRunLoop();

    @Method(selector="addTimer:forMode:")
    private native void addTimer0(NSTimer var1, String var2);

    @Method(selector="addPort:forMode:")
    private native void addPort0(NSPort var1, String var2);

    @Method(selector="removePort:forMode:")
    private native void removePort0(NSPort var1, String var2);

    @Method(selector="limitDateForMode:")
    public native NSDate getDateLimit(String var1);

    @Method(selector="acceptInputForMode:beforeDate:")
    public native void acceptInputUntil(String var1, NSDate var2);

    @Method(selector="currentRunLoop")
    public static native NSRunLoop getCurrent();

    @Method(selector="mainRunLoop")
    public static native NSRunLoop getMain();

    @Method(selector="run")
    public native void run();

    @Method(selector="runUntilDate:")
    public native void runUntil(NSDate var1);

    @Method(selector="runMode:beforeDate:")
    public native boolean runUntil(String var1, NSDate var2);

    @Method(selector="performSelector:target:argument:order:modes:")
    public native void perform(Selector var1, NSObject var2, NSObject var3, @MachineSizedUInt long var4, @Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var6);

    @Method(selector="cancelPerformSelector:target:argument:")
    public native void cancel(Selector var1, NSObject var2, NSObject var3);

    @Method(selector="cancelPerformSelectorsWithTarget:")
    public native void cancel(NSObject var1);

    static {
        ObjCRuntime.bind(NSRunLoop.class);
    }

    public static class NSRunLoopPtr
    extends Ptr<NSRunLoop, NSRunLoopPtr> {
    }
}

