/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
public class NSRange
extends Struct<NSRange> {
    public NSRange() {
    }

    public NSRange(@MachineSizedUInt long location, @MachineSizedUInt long length) {
        this.setLocation(location);
        this.setLength(length);
    }

    @StructMember(value=0)
    @MachineSizedUInt
    public native long getLocation();

    @StructMember(value=0)
    public native NSRange setLocation(@MachineSizedUInt long var1);

    @StructMember(value=1)
    @MachineSizedUInt
    public native long getLength();

    @StructMember(value=1)
    public native NSRange setLength(@MachineSizedUInt long var1);

    public long getMaxRange() {
        return this.getLocation() + this.getLength();
    }

    public boolean isLocationInRange(long location) {
        return location >= this.getLocation() && location - this.getLocation() < this.getLength();
    }

    public boolean equalsTo(NSRange other) {
        return this.getLocation() == other.getLocation() && this.getLength() == other.getLength();
    }

    public boolean equals(Object obj) {
        return obj instanceof NSRange && this.equalsTo((NSRange)((Object)obj));
    }

    @Bridge(symbol="NSUnionRange", optional=true)
    @ByVal
    public static native NSRange union(@ByVal NSRange var0, @ByVal NSRange var1);

    @Bridge(symbol="NSIntersectionRange", optional=true)
    @ByVal
    public static native NSRange intersection(@ByVal NSRange var0, @ByVal NSRange var1);

    @Bridge(symbol="NSStringFromRange", optional=true)
    protected static native String toString(@ByVal NSRange var0);

    @Bridge(symbol="NSRangeFromString", optional=true)
    @ByVal
    public static native NSRange fromString(String var0);

    static {
        Bro.bind(NSRange.class);
    }

    public static class NSRangePtr
    extends Ptr<NSRange, NSRangePtr> {
    }
}

