/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSInputStream;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOutputStream;
import org.robovm.apple.foundation.NSPropertyList;
import org.robovm.apple.foundation.NSPropertyListFormat;
import org.robovm.apple.foundation.NSPropertyListMutabilityOptions;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSPropertyListSerialization
extends NSObject {
    public NSPropertyListSerialization() {
    }

    protected NSPropertyListSerialization(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public static NSPropertyList getPropertyListFromData(NSData data, NSPropertyListMutabilityOptions opt) throws NSErrorException {
        return NSPropertyListSerialization.getPropertyListFromData(data, opt, null);
    }

    public static NSPropertyList getPropertyListFromStream(NSInputStream stream, NSPropertyListMutabilityOptions opt) throws NSErrorException {
        return NSPropertyListSerialization.getPropertyListFromStream(stream, opt, null);
    }

    @Method(selector="propertyList:isValidForFormat:")
    public static native boolean isPropertyListValidForFormat(NSPropertyList var0, NSPropertyListFormat var1);

    public static NSData getDataFromPropertyList(NSPropertyList plist, NSPropertyListFormat format, @MachineSizedUInt long opt) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = NSPropertyListSerialization.getDataFromPropertyList(plist, format, opt, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="dataWithPropertyList:format:options:error:")
    private static native NSData getDataFromPropertyList(NSPropertyList var0, NSPropertyListFormat var1, @MachineSizedUInt long var2, NSError.NSErrorPtr var4);

    @MachineSizedSInt
    public static long writePropertyListToStream(NSPropertyList plist, NSOutputStream stream, NSPropertyListFormat format, @MachineSizedUInt long opt) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long result = NSPropertyListSerialization.writePropertyListToStream(plist, stream, format, opt, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writePropertyList:toStream:format:options:error:")
    @MachineSizedSInt
    private static native long writePropertyListToStream(NSPropertyList var0, NSOutputStream var1, NSPropertyListFormat var2, @MachineSizedUInt long var3, NSError.NSErrorPtr var5);

    protected static NSPropertyList getPropertyListFromData(NSData data, NSPropertyListMutabilityOptions opt, MachineSizedUIntPtr format) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPropertyList result = NSPropertyListSerialization.getPropertyListFromData(data, opt, format, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="propertyListWithData:options:format:error:")
    private static native NSPropertyList getPropertyListFromData(NSData var0, NSPropertyListMutabilityOptions var1, MachineSizedUIntPtr var2, NSError.NSErrorPtr var3);

    protected static NSPropertyList getPropertyListFromStream(NSInputStream stream, NSPropertyListMutabilityOptions opt, MachineSizedUIntPtr format) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPropertyList result = NSPropertyListSerialization.getPropertyListFromStream(stream, opt, format, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="propertyListWithStream:options:format:error:")
    private static native NSPropertyList getPropertyListFromStream(NSInputStream var0, NSPropertyListMutabilityOptions var1, MachineSizedUIntPtr var2, NSError.NSErrorPtr var3);

    @Deprecated
    @Method(selector="dataFromPropertyList:format:errorDescription:")
    protected static native NSData getDataFromPropertyList(NSObject var0, NSPropertyListFormat var1, NSString.NSStringPtr var2);

    @Deprecated
    @Method(selector="propertyListFromData:mutabilityOption:format:errorDescription:")
    protected static native NSPropertyList getPropertyListFromData(NSData var0, NSPropertyListMutabilityOptions var1, MachineSizedUIntPtr var2, NSString.NSStringPtr var3);

    static {
        ObjCRuntime.bind(NSPropertyListSerialization.class);
    }

    public static class NSPropertyListSerializationPtr
    extends Ptr<NSPropertyListSerialization, NSPropertyListSerializationPtr> {
    }
}

