/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSProgressFileOperationKind;
import org.robovm.apple.foundation.NSProgressUserInfoKey;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSProgressUserInfo {
    private NSDictionary<NSString, NSObject> data;

    protected NSProgressUserInfo(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSProgressUserInfo() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSProgressUserInfo set(String key, NSObject value) {
        this.data.put(new NSString(key), value);
        return this;
    }

    public NSProgressUserInfo set(NSProgressUserInfoKey key, NSObject value) {
        this.data.put(key.value(), value);
        return this;
    }

    public NSObject get(String key) {
        return this.data.get(new NSString(key));
    }

    public NSObject get(NSProgressUserInfoKey key) {
        return this.data.get(key.value());
    }

    public boolean contains(String key) {
        return this.data.containsKey(new NSString(key));
    }

    public boolean contains(NSProgressUserInfoKey key) {
        return this.data.containsKey(key.value());
    }

    public double getEstimatedTimeRemaining() {
        if (this.contains(NSProgressUserInfoKey.EstimatedTimeRemaining)) {
            NSNumber val = (NSNumber)this.get(NSProgressUserInfoKey.EstimatedTimeRemaining);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSProgressUserInfo setEstimatedTimeRemaining(double timeRemaining) {
        this.set(NSProgressUserInfoKey.EstimatedTimeRemaining, (NSObject)NSNumber.valueOf(timeRemaining));
        return this;
    }

    public long getThroughput() {
        if (this.contains(NSProgressUserInfoKey.Throughput)) {
            NSNumber val = (NSNumber)this.get(NSProgressUserInfoKey.Throughput);
            return val.longValue();
        }
        return 0L;
    }

    public NSProgressUserInfo setThroughput(long throughput) {
        this.set(NSProgressUserInfoKey.Throughput, (NSObject)NSNumber.valueOf(throughput));
        return this;
    }

    public NSProgressFileOperationKind getFileOperationKind() {
        if (this.contains(NSProgressUserInfoKey.FileOperationKind)) {
            NSString val = (NSString)this.get(NSProgressUserInfoKey.FileOperationKind);
            return NSProgressFileOperationKind.valueOf(val);
        }
        return null;
    }

    public NSProgressUserInfo setFileOperationKind(NSProgressFileOperationKind kind) {
        this.set(NSProgressUserInfoKey.FileOperationKind, (NSObject)kind.value());
        return this;
    }

    public NSURL getFileURL() {
        if (this.contains(NSProgressUserInfoKey.FileURL)) {
            NSURL val = (NSURL)this.get(NSProgressUserInfoKey.FileURL);
            return val;
        }
        return null;
    }

    public NSProgressUserInfo setFileURL(NSURL url) {
        this.set(NSProgressUserInfoKey.FileURL, (NSObject)url);
        return this;
    }

    public long getTotalFileCount() {
        if (this.contains(NSProgressUserInfoKey.FileTotalCount)) {
            NSNumber val = (NSNumber)this.get(NSProgressUserInfoKey.FileTotalCount);
            return val.longValue();
        }
        return 0L;
    }

    public NSProgressUserInfo setTotalFileCount(long fileCount) {
        this.set(NSProgressUserInfoKey.FileTotalCount, (NSObject)NSNumber.valueOf(fileCount));
        return this;
    }

    public long getCompletedFileCount() {
        if (this.contains(NSProgressUserInfoKey.FileCompletedCount)) {
            NSNumber val = (NSNumber)this.get(NSProgressUserInfoKey.FileCompletedCount);
            return val.longValue();
        }
        return 0L;
    }

    public NSProgressUserInfo setCompletedFileCount(long fileCount) {
        this.set(NSProgressUserInfoKey.FileCompletedCount, (NSObject)NSNumber.valueOf(fileCount));
        return this;
    }

    static {
        Bro.bind(NSProgressUserInfo.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSProgressUserInfo toObject(Class<NSProgressUserInfo> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSProgressUserInfo(o);
        }

        @MarshalsPointer
        public static long toNative(NSProgressUserInfo o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

