/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.nio.ByteBuffer;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSMutableData;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSStream;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSOutputStream
extends NSStream {
    protected NSOutputStream(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSOutputStream() {
        super(null);
        this.initObject(this.init());
    }

    public NSOutputStream(NSURL url, boolean shouldAppend) {
        super(null);
        this.initObject(this.init(url, shouldAppend));
    }

    public NSOutputStream(String path, boolean shouldAppend) {
        super(null);
        this.initObject(this.init(path, shouldAppend));
    }

    public NSOutputStream(byte[] bytes) {
        super(null);
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.initObject(this.init(VM.getArrayValuesAddress((Object)bytes), bytes.length));
    }

    public NSOutputStream(ByteBuffer bytes) {
        super(null);
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        long handle = NSData.getEffectiveAddress(bytes) + (long)bytes.position();
        this.initObject(this.init(handle, bytes.remaining()));
        this.addStrongRef(bytes);
    }

    @Property(selector="hasSpaceAvailable")
    public native boolean hasSpaceAvailable();

    public long write(BytePtr buffer, long len) {
        return this.write(buffer.getHandle(), len);
    }

    public long write(ByteBuffer bytes) {
        long handle = NSData.getEffectiveAddress(bytes) + (long)bytes.position();
        return this.write(handle, (long)bytes.remaining());
    }

    public long write(byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    public long write(byte[] bytes, int offset, int length) {
        NSMutableData.checkOffsetAndCount(bytes.length, offset, length);
        if (length == 0) {
            return 0L;
        }
        return this.write(VM.getArrayValuesAddress((Object)bytes) + (long)offset, (long)length);
    }

    @Method(selector="write:maxLength:")
    @MachineSizedSInt
    protected native long write(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="initToMemory")
    @Pointer
    protected native long init();

    @Method(selector="initToBuffer:capacity:")
    @Pointer
    protected native long init(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="initWithURL:append:")
    @Pointer
    protected native long init(NSURL var1, boolean var2);

    @Method(selector="initToFileAtPath:append:")
    @Pointer
    protected native long init(String var1, boolean var2);

    static {
        ObjCRuntime.bind(NSOutputStream.class);
    }

    public static class NSOutputStreamPtr
    extends Ptr<NSOutputStream, NSOutputStreamPtr> {
    }
}

