/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNetServiceErrorCode;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSNetServiceErrorInfo
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected NSNetServiceErrorInfo(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSNetServiceErrorCode getErrorCode() {
        if (this.data.containsKey(NSNetServiceErrorInfo.ErrorCodeKey())) {
            NSNumber val = (NSNumber)this.data.get(NSNetServiceErrorInfo.ErrorCodeKey());
            NSNetServiceErrorCode code = null;
            try {
                code = NSNetServiceErrorCode.valueOf(val.intValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return code;
        }
        return null;
    }

    public NSObject getErrorDomain() {
        if (this.data.containsKey(NSNetServiceErrorInfo.ErrorDomainKey())) {
            Object val = this.data.get(NSNetServiceErrorInfo.ErrorDomainKey());
            return val;
        }
        return null;
    }

    @GlobalValue(symbol="NSNetServicesErrorCode", optional=true)
    protected static native NSString ErrorCodeKey();

    @GlobalValue(symbol="NSNetServicesErrorDomain", optional=true)
    protected static native NSString ErrorDomainKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSNetServiceErrorInfo.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSNetServiceErrorInfo toObject(Class<NSNetServiceErrorInfo> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSNetServiceErrorInfo(o);
        }

        @MarshalsPointer
        public static long toNative(NSNetServiceErrorInfo o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

