/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.util.Map;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMutableDictionary<K extends NSObject, V extends NSObject>
extends NSDictionary<K, V> {
    protected NSMutableDictionary(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSMutableDictionary(@MachineSizedUInt long numItems) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(numItems));
    }

    public NSMutableDictionary() {
    }

    public NSMutableDictionary(K k, V v) {
        super(k, v);
    }

    public NSMutableDictionary(K k1, V v1, K k2, V v2) {
        super(k1, v1, k2, v2);
    }

    public NSMutableDictionary(K k1, V v1, K k2, V v2, K k3, V v3) {
        super(k1, v1, k2, v2, k3, v3);
    }

    public NSMutableDictionary(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        super(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public NSMutableDictionary(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        super(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public NSMutableDictionary(Map<K, V> m) {
        super(m);
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }

    @Override
    public V remove(Object key) {
        if (!(key instanceof NSObject)) {
            return null;
        }
        Object oldValue = this.get(key);
        this.removeObject((NSObject)key);
        return (V)oldValue;
    }

    @Override
    public V put(K key, V value) {
        NSMutableDictionary.checkNull(key, value);
        Object oldValue = this.get(key);
        this.setObject((NSObject)value, (NSObject)key);
        return (V)oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put((K)((NSObject)entry.getKey()), (V)((NSObject)entry.getValue()));
        }
    }

    public static <V extends NSObject> NSMutableDictionary<NSString, V> fromStringMap(Map<String, V> map) {
        NSMutableDictionary<NSString, NSObject> dictionary = new NSMutableDictionary<NSString, NSObject>();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            dictionary.put(new NSString(entry.getKey()), (NSObject)entry.getValue());
        }
        return dictionary;
    }

    public static NSMutableDictionary<?, ?> read(File file) {
        return NSMutableDictionary.read(file.getAbsolutePath());
    }

    @Method(selector="dictionaryWithContentsOfFile:")
    protected static native NSMutableDictionary<?, ?> read(String var0);

    @Method(selector="dictionaryWithContentsOfURL:")
    public static native NSMutableDictionary<?, ?> read(NSURL var0);

    @Method(selector="removeObjectForKey:")
    protected native void removeObject(NSObject var1);

    @Method(selector="setObject:forKey:")
    protected native void setObject(NSObject var1, NSObject var2);

    @Method(selector="initWithCapacity:")
    @Pointer
    protected native long init(@MachineSizedUInt long var1);

    @Method(selector="removeAllObjects")
    protected native void removeAllObjects();

    static {
        ObjCRuntime.bind(NSMutableDictionary.class);
    }

    public static class NSMutableDictionaryPtr<K extends NSObject, V extends NSObject>
    extends Ptr<NSMutableDictionary<K, V>, NSMutableDictionaryPtr<K, V>> {
    }
}

